package org.nakedobjects.plugins.htmlviewer.webapp;

import javax.servlet.ServletContext;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.installers.JavaReflectorInstaller;
import org.nakedobjects.runtime.system.installers.NakedObjectsSystemUsingInstallers;

public class NakedObjectsSystemUsingInstallersWithinWebApp extends NakedObjectsSystemUsingInstallers {

    public static final Logger LOG = Logger.getLogger(NakedObjectsSystemUsingInstallers.class);

    private ServletContext servletContext;

    /**
     * As per superclass but looks up reflector from {@link ServletContext}.
     */
    public NakedObjectsSystemUsingInstallersWithinWebApp(
            final DeploymentType deploymentType, 
            final InstallerLookup installerLookup, 
            final ServletContext servletContext) {
        super(deploymentType, installerLookup);
        this.servletContext = servletContext;

        final NakedObjectReflectorInstaller reflectorInstaller = 
            (NakedObjectReflectorInstaller) installer("reflector", JavaReflectorInstaller.class);
        setReflectorInstaller(reflectorInstaller);

    }

    private Installer installer(
            final String installerName, final Class<?> defaultClass) {
        String installerClassName = servletContext.getInitParameter(installerName);
        
        boolean defaultUsed = false;
        if (installerClassName == null && defaultClass != null) {
            installerClassName = defaultClass.getName();
            defaultUsed = true;
        }
        if (installerClassName == null) {
            LOG.info("No " + installerName + " installer class specified");
            return null;
        }

        final Installer installer = getInstallerLookup().getInstaller(installerClassName);
        LOG.info(installerName + " installer " + installer + (defaultUsed ? " (default)" : ""));
        return installer;
    }


}


// Copyright (c) Naked Objects Group Ltd.
