package org.nakedobjects.plugins.htmlviewer.client;

import java.io.File;

import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.plugins.htmlviewer.component.ImageLookup;
import org.nakedobjects.plugins.htmlviewer.servlet.SessionAccess;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.client.NakedObjectClient;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.DeploymentType;


public class JettyHostingHtmlViewerClient implements NakedObjectClient {

    private static final String VIEWER_HTML_RESOURCE_BASE_KEY = ConfigurationConstants.ROOT + "viewer.html.resourceBase";
    private static final String VIEWER_HTML_PORT_KEY = ConfigurationConstants.ROOT + "viewer.html.port";
    private static final int VIEWER_HTML_PORT_DEFAULT = 8080;

    private AuthenticationManager authenticationManager;
    private DeploymentType deploymentType;
    private LogonFixture logonFixture;

    // ///////////////////////////////////////////////////////
    // title
    // ///////////////////////////////////////////////////////

    public void setTitle(final String title) {}

    // ///////////////////////////////////////////////////////
    // run, shutdown
    // ///////////////////////////////////////////////////////

    public void run() {
        final String resourceBaseDir = NakedObjectsContext.getConfiguration().getString(VIEWER_HTML_RESOURCE_BASE_KEY);
        if (resourceBaseDir != null) {
            final String imagesDir = resourceBaseDir + File.separator + "images";
            if (fileExists(imagesDir)) {
                ImageLookup.setImageDirectory(imagesDir);
            }
        } else {
            /*
             * The following three directories allow for the different places files are to be found within the
             * different file layouts. These are for Maven/Eclipse, and the demo and examples directories in
             * the distributions.
             */
            if (fileExists("images")) {
                ImageLookup.setImageDirectory("images");
            } else if (fileExists("web/images")) {
                ImageLookup.setImageDirectory("web/images");
            } else {
                ImageLookup.setImageDirectory("src/main/resources/images");
            }
        }

        final int port = NakedObjectsContext.getConfiguration().getInteger(VIEWER_HTML_PORT_KEY, VIEWER_HTML_PORT_DEFAULT);

        SessionAccess.createInstance(authenticationManager, deploymentType, logonFixture);
        new JettyHostingHtmlViewerWebServer().init(port, resourceBaseDir);

    }

    public void shutdown() {}

    /**
     * Helper
     */
    private boolean fileExists(final String fileName) {
        return new File(fileName).exists();
    }

    // ///////////////////////////////////////////////////////
    // Settings
    // ///////////////////////////////////////////////////////

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public void setLogonFixture(final LogonFixture logonFixture) {
        this.logonFixture = logonFixture;
    }

    public void setAuthenticationRequestViaArgs(final AuthenticationRequest authenticationRequest) {
    // does nothing.
    }

    // ///////////////////////////////////////////////////////
    // Dependencies
    // ///////////////////////////////////////////////////////

    public void setAuthenticationManager(final AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

}

// Copyright (c) Naked Objects Group Ltd.
