package org.nakedobjects.plugins.htmlviewer.client;

import java.util.List;

import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.nakedobjects.plugins.htmlviewer.servlet.Controller;
import org.nakedobjects.plugins.htmlviewer.servlet.Logon;


public class JettyHostingHtmlViewerWebServer extends JettyWebServerAbstract {

    protected void doAddResourceBases(final List<String> resourceBases) {
        resourceBases.add("./src/main/webapp");
        resourceBases.add("./src/main/resources");
        resourceBases.add("./web");
        resourceBases.add(".");
    }

    protected String[] doGetWelcomeFiles() {
        return new String[] { "logon.app" };
    }

    protected void doAddServletMappings(final ServletHandler servletHandler) {
        servletHandler.addServletWithMapping(new ServletHolder(Logon.class), "/logon.app");
        servletHandler.addServletWithMapping(new ServletHolder(Controller.class), "*.app");
    }
}
