package org.nakedobjects.plugins.htmlviewer.client;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

import org.apache.log4j.Logger;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.nakedobjects.plugins.htmlviewer.servlet.ResourceServlet;


public abstract class JettyWebServerAbstract {
    
    private final static Logger LOG = Logger.getLogger(JettyWebServerAbstract.class);

    /////////////////////////////////////////////////////////
    // Constructor
    /////////////////////////////////////////////////////////

    public JettyWebServerAbstract() {
    }

    
    /////////////////////////////////////////////////////////
    // init
    /////////////////////////////////////////////////////////

    public ContextHandler init(final int port, final String resourceBase) {
        return init(port, null, resourceBase);
    }

    private ContextHandler init(final int port, final EventListener servletInitializer, final String resourceBase) {
        final Server server = new Server(port);

        final ContextHandler context = new ContextHandler("/");
        context.setClassLoader(Thread.currentThread().getContextClassLoader());

        if (servletInitializer != null) {
            context.addEventListener(servletInitializer);
        }
        server.addHandler(context);

        final HandlerList handlerList = new HandlerList();

        final List<String> resourceBases = new ArrayList<String>();
        addResourceBases(resourceBases);

        if (resourceBase != null) {
            resourceBases.add(resourceBase);
        }
        for(String rb: resourceBases) {
            final ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setResourceBase(rb);
            resourceHandler.setWelcomeFiles(getWelcomeFiles());
            handlerList.addHandler(resourceHandler);
        }

        final SessionHandler sessionHandler = new SessionHandler();
        handlerList.addHandler(sessionHandler);

        final ServletHandler servletHandler = new ServletHandler();
        sessionHandler.setHandler(servletHandler);

        addServletMappings(servletHandler);
        
        ServletHolder imageServletHolder = new ServletHolder(ResourceServlet.class);
        servletHandler.addServlet(imageServletHolder);
        
        ServletMapping imageServletMapping = new ServletMapping();
        imageServletMapping.setServletName(imageServletHolder.getName());
        imageServletMapping.setPathSpecs(new String[]{"*.gif", "*.png", "*.css"});
        servletHandler.addServletMapping(imageServletMapping);
        
        context.setHandler(handlerList);


        LOG.info("Starting web server: open a web browser and use URL http://localhost:8080/logon.app to connect");
        try {
            server.start();
            // server.join();
        } catch (final RuntimeException e) {
            throw e;
        } catch (final Exception e) {
            throw new JettyWebServerException("Web server failed to start", e);
        }
        
        return context;
    }


    private void addResourceBases(final List<String> resourceBases) {
        doAddResourceBases(resourceBases);
    }


    protected abstract void doAddResourceBases(final List<String> resourceBases);


    private String[] getWelcomeFiles() {
        return doGetWelcomeFiles();
    }


    protected abstract String[] doGetWelcomeFiles();


    private void addServletMappings(final ServletHandler servletHandler) {
        doAddServletMappings(servletHandler);
    }


    protected abstract void doAddServletMappings(final ServletHandler servletHandler);
}
