/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.client;

import java.io.File;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.plugins.htmlviewer.client.JettyHostingHtmlViewerWebServer;
import org.nakedobjects.plugins.htmlviewer.component.ImageLookup;
import org.nakedobjects.plugins.htmlviewer.servlet.SessionAccess;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.client.NakedObjectClient;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.DeploymentType;

public class JettyHostingHtmlViewerClient
implements NakedObjectClient {
    private static final String VIEWER_HTML_RESOURCE_BASE_KEY = "nakedobjects.viewer.html.resourceBase";
    private static final String VIEWER_HTML_PORT_KEY = "nakedobjects.viewer.html.port";
    private static final int VIEWER_HTML_PORT_DEFAULT = 8080;
    private AuthenticationManager authenticationManager;
    private DeploymentType deploymentType;
    private LogonFixture logonFixture;

    public void setTitle(String title) {
    }

    public void run() {
        String resourceBaseDir = NakedObjectsContext.getConfiguration().getString(VIEWER_HTML_RESOURCE_BASE_KEY);
        if (resourceBaseDir != null) {
            String imagesDir = resourceBaseDir + File.separator + "images";
            if (this.fileExists(imagesDir)) {
                ImageLookup.setImageDirectory((String)imagesDir);
            }
        } else if (this.fileExists("images")) {
            ImageLookup.setImageDirectory((String)"images");
        } else if (this.fileExists("web/images")) {
            ImageLookup.setImageDirectory((String)"web/images");
        } else {
            ImageLookup.setImageDirectory((String)"src/main/resources/images");
        }
        int port = NakedObjectsContext.getConfiguration().getInteger(VIEWER_HTML_PORT_KEY, 8080);
        SessionAccess.createInstance((AuthenticationManager)this.authenticationManager, (DeploymentType)this.deploymentType, (LogonFixture)this.logonFixture);
        new JettyHostingHtmlViewerWebServer().init(port, resourceBaseDir);
    }

    public void shutdown() {
    }

    private boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public void setLogonFixture(LogonFixture logonFixture) {
        this.logonFixture = logonFixture;
    }

    public void setAuthenticationRequestViaArgs(AuthenticationRequest authenticationRequest) {
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

