/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.client;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.nakedobjects.plugins.htmlviewer.client.JettyWebServerException;
import org.nakedobjects.plugins.htmlviewer.servlet.ResourceServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JettyWebServerAbstract {
    private static final Logger LOG = Logger.getLogger(JettyWebServerAbstract.class);

    public ContextHandler init(int port, String resourceBase) {
        return this.init(port, null, resourceBase);
    }

    private ContextHandler init(int port, EventListener servletInitializer, String resourceBase) {
        Server server = new Server(port);
        ContextHandler context = new ContextHandler("/");
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        if (servletInitializer != null) {
            context.addEventListener(servletInitializer);
        }
        server.addHandler((Handler)context);
        HandlerList handlerList = new HandlerList();
        ArrayList<String> resourceBases = new ArrayList<String>();
        this.addResourceBases(resourceBases);
        if (resourceBase != null) {
            resourceBases.add(resourceBase);
        }
        for (String rb : resourceBases) {
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setResourceBase(rb);
            resourceHandler.setWelcomeFiles(this.getWelcomeFiles());
            handlerList.addHandler((Handler)resourceHandler);
        }
        SessionHandler sessionHandler = new SessionHandler();
        handlerList.addHandler((Handler)sessionHandler);
        ServletHandler servletHandler = new ServletHandler();
        sessionHandler.setHandler((Handler)servletHandler);
        this.addServletMappings(servletHandler);
        ServletHolder imageServletHolder = new ServletHolder(ResourceServlet.class);
        servletHandler.addServlet(imageServletHolder);
        ServletMapping imageServletMapping = new ServletMapping();
        imageServletMapping.setServletName(imageServletHolder.getName());
        imageServletMapping.setPathSpecs(new String[]{"*.gif", "*.png", "*.css"});
        servletHandler.addServletMapping(imageServletMapping);
        context.setHandler((Handler)handlerList);
        LOG.info((Object)"Starting web server: open a web browser and use URL http://localhost:8080/logon.app to connect");
        try {
            server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JettyWebServerException("Web server failed to start", e);
        }
        return context;
    }

    private void addResourceBases(List<String> resourceBases) {
        this.doAddResourceBases(resourceBases);
    }

    protected abstract void doAddResourceBases(List<String> var1);

    private String[] getWelcomeFiles() {
        return this.doGetWelcomeFiles();
    }

    protected abstract String[] doGetWelcomeFiles();

    private void addServletMappings(ServletHandler servletHandler) {
        this.doAddServletMappings(servletHandler);
    }

    protected abstract void doAddServletMappings(ServletHandler var1);
}

