package org.nakedobjects.plugins.htmlviewer.session;

import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.request.Action;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.servlet.SessionAccess;
import org.nakedobjects.plugins.htmlviewer.request.Request;
import org.nakedobjects.plugins.htmlviewer.request.Task;



public class LogOut implements Action {
    public void execute(final Request request, final Context context, final Page page) {
        SessionAccess.logoffUser(context.getSession());
        context.setSession(null);
        context.invalidate();
    }

    public String name() {
        return "logout";
    }
}

// Copyright (c) Naked Objects Group Ltd.
