package org.nakedobjects.plugins.htmlviewer.task;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.request.Action;
import org.nakedobjects.plugins.htmlviewer.request.ActionException;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.ForwardRequest;
import org.nakedobjects.plugins.htmlviewer.request.Request;
import org.nakedobjects.plugins.htmlviewer.request.Task;



public class EditObject implements Action {

    public void execute(final Request request, final Context context, final Page page) {
        final String idString = request.getObjectId();
        if (idString == null) {
            throw new ActionException("Task no longer in progress");
        }
        final NakedObject object = context.getMappedObject(idString);
        if (object.getResolveState() != ResolveState.TRANSIENT) {
            context.setObjectCrumb(object);
        }
        final EditTask editTask = new EditTask(context, object);
        context.addTaskCrumb(editTask);
        request.forward(ForwardRequest.task(editTask));
    }

    public String name() {
        return Request.EDIT_COMMAND;
    }
}

// Copyright (c) Naked Objects Group Ltd.
