/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.request;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectActionNoop;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.plugins.htmlviewer.request.ActionException;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyNakedCollection;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

public class ContextTest
extends ProxyJunit3TestCase {
    private Context context;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new Context(null);
    }

    public void testExceptionThrownWhenNoCollectionForIdentity() {
        this.context.mapCollection((NakedObject)this.system.createPersistentTestCollection());
        try {
            ContextTest.assertNull((Object)this.context.getMappedCollection("112"));
            ContextTest.fail();
        }
        catch (ActionException actionException) {
            // empty catch block
        }
    }

    public void testExceptionThrownWhenNoObjectForIdentity() {
        this.context.mapAction((NakedObjectAction)new NakedObjectActionNoop());
        try {
            ContextTest.assertNull((Object)this.context.getMappedAction("112"));
            ContextTest.fail();
        }
        catch (ActionException actionException) {
            // empty catch block
        }
    }

    public void testExceptionThrownWhenNoActionForIdentity() {
        NakedObject object = this.system.createPersistentTestObject();
        this.context.mapObject(object);
        try {
            ContextTest.assertNull((Object)this.context.getMappedObject("112"));
            ContextTest.fail();
        }
        catch (ActionException actionException) {
            // empty catch block
        }
    }

    public void testIdentityUsedToLookupObject() {
        NakedObject object = this.system.createPersistentTestObject();
        String id = this.context.mapObject(object);
        ContextTest.assertEquals((Object)object, (Object)this.context.getMappedObject(id));
    }

    public void testLookedUpObjectHasDifferentVersion() {
        NakedObject object = this.system.createPersistentTestObject();
        String id = this.context.mapObject(object);
        object.setOptimisticLock((Version)new TestProxyVersion(5));
        this.context.getMappedObject(id);
        ContextTest.assertEquals((String)("Reloaded object " + object.titleString()), (String)this.context.getMessage(1));
    }

    public void testIdentityUsedToLookupAction() {
        NakedObjectActionNoop action = new NakedObjectActionNoop();
        String id = this.context.mapAction((NakedObjectAction)action);
        ContextTest.assertEquals((Object)action, (Object)this.context.getMappedAction(id));
    }

    public void testRegisteredCollectionReturnSameIdentityForSameCollection() {
        TestProxyNakedCollection collection = this.system.createPersistentTestCollection();
        String id = this.context.mapCollection((NakedObject)collection);
        String id2 = this.context.mapCollection((NakedObject)collection);
        ContextTest.assertEquals((String)id, (String)id2);
    }

    public void testRegisteredObjectReturnSameIdentityForSameObject() {
        NakedObject object = this.system.createPersistentTestObject();
        String id = this.context.mapObject(object);
        String id2 = this.context.mapObject(object);
        ContextTest.assertEquals((String)id, (String)id2);
    }

    public void testTransientObjectReturnSameIdentityForSameObject() {
        NakedObject object = this.system.createTransientTestObject();
        String id = this.context.mapObject(object);
        String id2 = this.context.mapObject(object);
        ContextTest.assertEquals((String)id, (String)id2);
    }

    public void testRegisteredObjectReturnDifferentIdentityForDifferentObject() {
        NakedObject dummyNakedObject = this.system.createPersistentTestObject();
        NakedObject dummyNakedObject2 = this.system.createPersistentTestObject();
        String id = this.context.mapObject(dummyNakedObject);
        String id2 = this.context.mapObject(dummyNakedObject2);
        ContextTest.assertNotSame((Object)id, (Object)id2);
    }

    public void testRegisteredActionReturnSameIdentityForSameAction() {
        NakedObjectActionNoop action = new NakedObjectActionNoop();
        String id = this.context.mapAction((NakedObjectAction)action);
        String id2 = this.context.mapAction((NakedObjectAction)action);
        ContextTest.assertEquals((String)id, (String)id2);
    }

    public void testRegisteredActionReturnDifferentIdentityForDifferentAction() {
        String id = this.context.mapAction((NakedObjectAction)new NakedObjectActionNoop());
        String id2 = this.context.mapAction((NakedObjectAction)new NakedObjectActionNoop());
        ContextTest.assertNotSame((Object)id, (Object)id2);
    }

    public void testPersistentObjectsRestoredAsGhostToObjectLoader() {
        NakedObject object = this.system.createPersistentTestObject();
        this.context.mapObject(object);
        Oid oid = object.getOid();
        this.system.resetLoader();
        ContextTest.assertNull((String)"loader still has the object", (Object)ContextTest.getAdapterManager().getAdapterFor(oid));
        this.context.restoreAllObjectsToLoader();
        ContextTest.assertNotNull((String)"loaders is missing the object", (Object)ContextTest.getAdapterManager().getAdapterFor(oid));
        NakedObject newAdapter = ContextTest.getAdapterManager().getAdapterFor(oid);
        ContextTest.assertNotSame((String)"expect the loader to have a new adapter", (Object)object, (Object)newAdapter);
        ContextTest.assertEquals((String)"expect oids to match", (Object)object.getOid(), (Object)newAdapter.getOid());
        ContextTest.assertNotSame((Object)object.getObject(), (Object)newAdapter.getObject());
        ContextTest.assertEquals(object.getObject().getClass(), newAdapter.getObject().getClass());
        ContextTest.assertEquals((String)"expect versions to match", (Object)object.getVersion(), (Object)newAdapter.getVersion());
        ContextTest.assertEquals((Object)ResolveState.GHOST, (Object)newAdapter.getResolveState());
    }
}

