/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.component;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.htmlviewer.component.ImageProvider;

public class ImageProviderDirectoryBased
implements ImageProvider {
    private final String UNKNOWN_IMAGE = "Default";
    private final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private final Map images = new HashMap();
    private File imageDirectory;
    private String unknownImageFile;

    public void setImageDirectory(String imageDirectory) {
        this.imageDirectory = new File(imageDirectory);
        if (!this.imageDirectory.exists()) {
            throw new NakedObjectException("No image directory found: " + imageDirectory);
        }
        this.unknownImageFile = this.imageFile("Default");
    }

    public void debug(DebugString debug) {
        debug.appendTitle("Image Lookup");
        debug.indent();
        for (Object key : this.images.keySet()) {
            Object value = this.images.get(key);
            debug.appendln(key + " -> " + value);
        }
        debug.unindent();
    }

    private String imageFile(final String imageName) {
        String[] files = this.imageDirectory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    for (int i = 0; i < ImageProviderDirectoryBased.this.EXTENSIONS.length; ++i) {
                        if (!name.substring(0, dot).equalsIgnoreCase(imageName) || !name.substring(dot + 1).equalsIgnoreCase(ImageProviderDirectoryBased.this.EXTENSIONS[i])) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        return files.length == 0 ? null : files[0];
    }

    private String findImage(NakedObjectSpecification specification) {
        String name = specification.getShortName();
        String fileName = this.imageFile(name);
        if (fileName != null) {
            this.images.put(name, fileName);
            return fileName;
        }
        NakedObjectSpecification superclass = specification.superclass();
        if (superclass != null) {
            return this.findImage(superclass);
        }
        return this.unknownImageFile;
    }

    public String image(NakedObject object) {
        String iconName = object.getIconName();
        if (iconName != null) {
            return this.image(iconName);
        }
        return this.image(object.getSpecification());
    }

    public String image(NakedObjectSpecification specification) {
        String name = specification.getShortName();
        String imageName = (String)this.images.get(name);
        if (imageName != null) {
            return imageName;
        }
        return this.findImage(specification);
    }

    public String image(String name) {
        String imageName = (String)this.images.get(name);
        if (imageName != null) {
            return imageName;
        }
        String fileName = this.imageFile(name);
        return fileName == null ? this.unknownImageFile : fileName;
    }
}

