/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.object;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.component.ViewPane;
import org.nakedobjects.plugins.htmlviewer.object.Menu;
import org.nakedobjects.plugins.htmlviewer.request.Action;
import org.nakedobjects.plugins.htmlviewer.request.ActionException;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.Request;

public abstract class AbstractObjectView
implements Action {
    public final void execute(Request request, Context context, Page page) {
        String idString = request.getObjectId();
        NakedObject object = context.getMappedObject(idString);
        if (object == null) {
            throw new ActionException("No such object: " + idString);
        }
        page.setTitle(object.titleString());
        ViewPane content = page.getViewPane();
        content.setWarningsAndMessages(context.getMessages(), context.getWarnings());
        content.setTitle(object.titleString(), object.getSpecification().getDescription());
        content.setIconName(object.getIconName());
        if (this.addObjectToHistory()) {
            context.addObjectToHistory(idString);
        }
        context.purge();
        content.setMenu(Menu.menu(object, idString, context));
        String iconName = object.getIconName();
        if (iconName == null) {
            iconName = object.getSpecification().getShortName();
        }
        content.setIconName(iconName);
        String field = request.getProperty();
        this.doExecute(context, content, object, field);
        context.clearMessagesAndWarnings();
    }

    protected void doExecute(Context context, ViewPane content, NakedObject object, String field) {
    }

    protected boolean addObjectToHistory() {
        return false;
    }
}

