/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.object;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.plugins.htmlviewer.component.Block;
import org.nakedobjects.plugins.htmlviewer.component.Component;
import org.nakedobjects.plugins.htmlviewer.component.ComponentFactory;
import org.nakedobjects.plugins.htmlviewer.component.ViewPane;
import org.nakedobjects.plugins.htmlviewer.object.AbstractObjectView;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ObjectView
extends AbstractObjectView {
    protected boolean addObjectToHistory() {
        return true;
    }

    protected void doExecute(Context context, ViewPane content, NakedObject adapter, String field) {
        String id = context.mapObject(adapter);
        this.createObjectView(context, adapter, content, id);
        NakedObjectSpecification specification = adapter.getSpecification();
        boolean immutable = SpecificationFacets.isAlwaysImmutable((NakedObjectSpecification)specification) || adapter.isPersistent() && SpecificationFacets.isImmutableOncePersisted((NakedObjectSpecification)specification);
        boolean allFieldUneditable = true;
        NakedObjectAssociation[] flds = specification.getAssociations();
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].isUsable(NakedObjectsContext.getAuthenticationSession(), adapter).isAllowed()) continue;
            allFieldUneditable = false;
            break;
        }
        if (!immutable && !allFieldUneditable) {
            content.add(context.getComponentFactory().createEditOption(id));
        }
        context.setObjectCrumb(adapter);
    }

    private void createObjectView(Context context, NakedObject object, ViewPane pane, String id) {
        NakedObjectSpecification specification = object.getSpecification();
        NakedObjectAssociation[] visibleFields = specification.getAssociations(NakedObjectAssociationFilters.dynamicallyVisible((AuthenticationSession)NakedObjectsContext.getAuthenticationSession(), (NakedObject)object));
        for (int i = 0; i < visibleFields.length; ++i) {
            NakedObjectAssociation field = visibleFields[i];
            ComponentFactory factory = context.getComponentFactory();
            Block fieldBlock = factory.createBlock("field", field.getDescription());
            fieldBlock.add(factory.createInlineBlock("label", field.getName(), null));
            fieldBlock.add(factory.createInlineBlock("separator", ":  ", null));
            NakedObjectsContext.getPersistenceSession().resolveField(object, field);
            NakedObject associatedObject = field.get(object);
            Component component = null;
            if (field.getSpecification().isParseable()) {
                component = factory.createParseableField(field, associatedObject, false);
            } else if (field.isOneToOneAssociation()) {
                if (associatedObject == null) {
                    component = factory.createInlineBlock("value", "", null);
                    fieldBlock.add(component);
                } else {
                    String elementId = context.mapObject(associatedObject);
                    component = factory.createObjectIcon(field, associatedObject, elementId, "value");
                }
            } else if (field.isOneToManyAssociation()) {
                component = factory.createCollectionIcon(field, associatedObject, id);
            } else {
                throw new UnknownTypeException((Object)field);
            }
            fieldBlock.add(component);
            pane.add(fieldBlock);
        }
    }

    public String name() {
        return "object";
    }
}

