/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.request;

import java.util.Enumeration;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.htmlviewer.component.Table;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class TableBuilder {
    public static Table createTable(Context context, String id, NakedObject object, OneToManyAssociation collectionField) {
        NakedObject collection = collectionField.get(object);
        String name = collectionField.getName();
        NakedObjectSpecification type = collectionField.getSpecification();
        String summary = "Table showing elements of " + name + " field";
        return TableBuilder.createTable(context, collectionField != null, collection, summary, type);
    }

    public static Table createTable(Context context, boolean addSelector, NakedObject collection, String summary, NakedObjectSpecification elementType) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Enumeration elements = facet.elements(collection);
        NakedObjectAssociation[] visibleFields = elementType.getAssociations(NakedObjectAssociationFilters.STATICALLY_VISIBLE_ASSOCIATIONS);
        NakedObjectAssociation[] fields = new NakedObjectAssociation[visibleFields.length];
        int len = 0;
        for (int i = 0; i < visibleFields.length; ++i) {
            if (visibleFields[i].isOneToManyAssociation()) continue;
            fields[len++] = visibleFields[i];
        }
        Table table = context.getComponentFactory().createTable(len, addSelector);
        table.setSummary(summary);
        for (int i = 0; i < len; ++i) {
            table.addColumnHeader(fields[i].getName());
        }
        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject)elements.nextElement();
            NakedObjectsContext.getPersistenceSession().resolveImmediately(element);
            String elementId = context.mapObject(element);
            table.addRowHeader(context.getComponentFactory().createObjectIcon(element, elementId, "icon"));
            for (int i = 0; i < len; ++i) {
                NakedObject fld = fields[i].get(element);
                if (!fields[i].isVisible(NakedObjectsContext.getAuthenticationSession(), element).isAllowed()) {
                    table.addEmptyCell();
                    continue;
                }
                if (fld.getSpecification().isParseable()) {
                    String titleString = fld != null ? fld.titleString() : null;
                    MultiLineFacet multiline = (MultiLineFacet)fld.getSpecification().getFacet(MultiLineFacet.class);
                    boolean shouldTruncate = multiline != null && multiline.numberOfLines() > 1;
                    table.addCell(titleString, shouldTruncate);
                    continue;
                }
                if (fields[i].isOneToOneAssociation() && fld == null) {
                    table.addEmptyCell();
                    continue;
                }
                if (!fields[i].isOneToOneAssociation()) continue;
                NakedObjectsContext.getPersistenceSession().resolveImmediately(fld);
                String objectId = context.mapObject(fld);
                table.addCell(context.getComponentFactory().createObjectIcon(fields[i], fld, objectId, "icon"));
            }
        }
        return table;
    }
}

