/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.task;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.Task;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

public class AddItemToCollectionTask
extends Task {
    private final OneToManyAssociation field;

    protected AddItemToCollectionTask(Context context, NakedObject target, OneToManyAssociation fld) {
        super(context, "Add to collection", "", target, 1);
        this.names[0] = fld.getName();
        this.descriptions[0] = fld.getDescription();
        this.fieldSpecifications[0] = fld.getSpecification();
        this.initialState[0] = null;
        this.optional[0] = true;
        this.field = fld;
    }

    public void checkForValidity(Context context) {
        NakedObject target = this.getTarget(context);
        NakedObject[] parameters = this.getEntries(context);
        Consent valueValid = this.field.isValidToAdd(target, parameters[0]);
        this.errors[0] = valueValid.getReason();
    }

    public void checkInstances(Context context, NakedObject[] objects) {
        NakedObject collection = this.field.get(this.getTarget(context));
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        NakedObject target = this.getTarget(context);
        for (int i = 0; i < objects.length; ++i) {
            Consent valueValid = this.field.isValidToAdd(target, objects[i]);
            if (valueValid.isVetoed()) {
                objects[i] = null;
                continue;
            }
            if (!facet.contains(collection, objects[i])) continue;
            objects[i] = null;
        }
    }

    public NakedObject completeTask(Context context, Page page) {
        NakedObject targetAdapter = this.getTarget(context);
        NakedObject[] parameterAdapters = this.getEntries(context);
        AddItemToCollectionTask.getTransactionManager().startTransaction();
        this.field.addElement(targetAdapter, parameterAdapters[0]);
        if (targetAdapter.isTransient()) {
            AddItemToCollectionTask.getPersistenceSession().makePersistent(targetAdapter);
        }
        AddItemToCollectionTask.getTransactionManager().endTransaction();
        return targetAdapter;
    }

    public boolean isEditing() {
        return true;
    }

    private static NakedObjectTransactionManager getTransactionManager() {
        return AddItemToCollectionTask.getPersistenceSession().getTransactionManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

