package org.nakedobjects.plugins.htmlviewer.html;

import java.io.PrintWriter;


public class Heading extends AbstractComponent {
    private final String title;
    private final int level;

    public Heading(final String title) {
        this(title, 1);
    }

    public Heading(final String title, final int level) {
        this.title = title;
        this.level = level;
    }

    public void write(final PrintWriter writer) {
        writeTag(writer, "h" + level);
        writer.print(title);
        writer.print("</h");
        writer.print(level);
        writer.println(">");
    }

}

// Copyright (c) Naked Objects Group Ltd.
