package org.nakedobjects.plugins.htmlviewer.servlet;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.lang.IoUtils;
import org.nakedobjects.metamodel.commons.lang.Resources;


public class ResourceServlet extends HttpServlet {
    
    private static final long serialVersionUID = 1L;
    private final Logger LOG = Logger.getLogger(ResourceServlet.class);

    @Override
    protected void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,
            IOException {
        processRequest(request, response);
    }

    @Override
    protected void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,
            IOException {
        processRequest(request, response);
    }

    private void processRequest(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,
            IOException {
        String servletPath = stripLeadingSlash(request.getServletPath());
        LOG.info("request: " + servletPath);
        InputStream is = Resources.getResourceAsStream(servletPath);
        if (is != null) {
            IoUtils.copy(is, response.getOutputStream());
        }
    }

    private String stripLeadingSlash(String servletPath) {
        if (!servletPath.startsWith("/")) {
            return servletPath;
        }
        if (servletPath.length() < 2) {
            return "";
        }
        return servletPath.substring(1);
    }
}

// Copyright (c) Naked Objects Group Ltd.
