/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.html;

import java.io.PrintWriter;
import org.nakedobjects.plugins.htmlviewer.component.Block;
import org.nakedobjects.plugins.htmlviewer.component.Component;
import org.nakedobjects.plugins.htmlviewer.html.CompositeComponent;
import org.nakedobjects.plugins.htmlviewer.html.Html;

public class Div
extends CompositeComponent
implements Block {
    private final String className;
    private final String id;
    private final String description;

    public Div(String className, String description) {
        this.className = className;
        this.description = description;
        this.id = null;
    }

    public Div(String className, String description, String id) {
        this.description = description;
        this.className = className;
        this.id = id;
    }

    public void write(PrintWriter writer) {
        super.write(writer);
    }

    protected void writeBefore(PrintWriter writer) {
        writer.print("<div");
        if (this.className != null) {
            writer.print(" class=\"");
            writer.print(this.className);
            writer.print("\"");
        }
        if (this.id != null) {
            writer.print(" id=\"");
            writer.print(this.id);
            writer.print("\"");
        }
        if (this.description != null) {
            writer.print(" title=\"");
            writer.print(this.description);
            writer.print("\"");
        }
        writer.print(">");
    }

    protected void writeAfter(PrintWriter writer) {
        writer.println("</div>");
    }

    public void add(Component component) {
        super.add(component);
    }

    public void add(String text) {
        super.add(new Html(text));
    }
}

