/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.request;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.htmlviewer.request.Crumb;
import org.nakedobjects.plugins.htmlviewer.request.ForwardRequest;
import org.nakedobjects.plugins.htmlviewer.request.Request;

public class ObjectCrumb
implements Crumb {
    private final String objectId;
    private final boolean isService;
    private final String title;

    public ObjectCrumb(String objectId, NakedObject object) {
        this.objectId = objectId;
        this.title = object.titleString();
        this.isService = object.getSpecification().isService();
    }

    public void debug(DebugString string) {
        string.appendln("Object Crumb");
        string.appendln("object", (Object)this.objectId);
        string.appendln("title", (Object)this.title);
        string.appendln("for service", this.isService);
    }

    public String title() {
        return this.title;
    }

    public String toString() {
        return new ToString((Object)this).append(this.title()).toString();
    }

    public Request changeContext() {
        if (this.isService) {
            return ForwardRequest.viewService(this.objectId);
        }
        return ForwardRequest.viewObject(this.objectId);
    }
}

