/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.htmlviewer.html.HtmlComponentFactory;
import org.nakedobjects.plugins.htmlviewer.html.LogonFormPage;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.servlet.SessionAccess;
import org.nakedobjects.runtime.authentication.PasswordAuthenticationRequest;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;

public class Logon
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(Logon.class);
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = request.getParameter("username");
        String password = request.getParameter("password");
        PasswordAuthenticationRequest passwordAuthenticationRequest = new PasswordAuthenticationRequest(user, password);
        if (user == null) {
            this.prompt(response, "", "", "");
        } else {
            AuthenticationSession session = null;
            session = SessionAccess.authenticate(passwordAuthenticationRequest);
            if (session != null) {
                Context context = new Context(new HtmlComponentFactory());
                context.setSession(session);
                HttpSession httpSession = request.getSession(true);
                httpSession.setAttribute("nof-context", (Object)context);
                LOG.info((Object)("created session: " + httpSession));
                this.loggedIn(response, user);
            } else {
                this.prompt(response, user, password, "error");
            }
        }
    }

    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doPost(arg0, arg1);
    }

    private void prompt(HttpServletResponse response, String user, String password, String message) throws IOException {
        response.setContentType("text/html");
        HtmlComponentFactory factory = new HtmlComponentFactory();
        LogonFormPage page = factory.createLogonPage(user, password);
        page.write(response.getWriter());
    }

    private void loggedIn(HttpServletResponse response, String user) throws IOException {
        Monitor.addEvent((String)"Web", (String)("Logon - " + user));
        response.sendRedirect("start.app");
    }
}

