/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.webapp;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoader;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoaderDefault;
import org.nakedobjects.plugins.htmlviewer.component.ImageLookup;
import org.nakedobjects.plugins.htmlviewer.servlet.SessionAccess;
import org.nakedobjects.plugins.htmlviewer.webapp.NakedObjectsSystemUsingInstallersWithinWebApp;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupImpl;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.installers.NakedObjectsSystemUsingInstallers;

public class ServletInitializer
implements ServletContextListener {
    private static final String SYSTEM_SERVLET_CONTEXT_KEY = "System";
    private static final Logger LOG = Logger.getLogger(ServletInitializer.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletInitializer instance = new ServletInitializer();
        instance.init(servletContextEvent.getServletContext());
    }

    private void init(ServletContext servletContext) {
        ImageLookup.setImageDirectory((String)servletContext.getRealPath("/images"));
        DeploymentType deploymentType = DeploymentType.SERVER;
        InstallerLookupImpl installerLookup = new InstallerLookupImpl(this.getClass());
        String dir = servletContext.getRealPath("/WEB-INF");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("current dir: " + new File(".").getAbsolutePath()));
            LOG.debug((Object)("real path: " + dir));
        }
        ConfigurationLoaderDefault configurationLoader = new ConfigurationLoaderDefault(dir);
        this.addConfigurationFiles(deploymentType, configurationLoader);
        installerLookup.setConfigurationLoader((ConfigurationLoader)configurationLoader);
        NakedObjectsSystemUsingInstallersWithinWebApp system = new NakedObjectsSystemUsingInstallersWithinWebApp(deploymentType, (InstallerLookup)installerLookup, servletContext);
        system.setHideSplash(true);
        system.lookupAndSetAuthenticatorInstaller();
        system.lookupAndSetUserProfileFactoryInstaller();
        system.lookupAndSetServerListenerInstaller();
        system.lookupAndSetFixturesInstaller();
        system.init();
        this.completeServletInitialization(servletContext, (NakedObjectsSystemUsingInstallers)system);
    }

    private void completeServletInitialization(ServletContext servletContext, NakedObjectsSystemUsingInstallers system) {
        SessionAccess.createInstance((AuthenticationManager)NakedObjectsContext.getAuthenticationManager());
        LOG.info((Object)"server started");
        servletContext.setAttribute(SYSTEM_SERVLET_CONTEXT_KEY, (Object)system);
    }

    private void addConfigurationFiles(DeploymentType deploymentType, ConfigurationLoaderDefault configurationLoader) {
        for (String config : new String[]{"web.properties", "war.properties"}) {
            if (config == null) continue;
            configurationLoader.addConfigurationFile(config, true);
        }
        String type = deploymentType.name().toLowerCase();
        configurationLoader.addConfigurationFile(type + ".properties", false);
    }

    public void contextDestroyed(ServletContextEvent ev) {
        LOG.info((Object)"server shutting down");
        NakedObjectsSystemUsingInstallers system = (NakedObjectsSystemUsingInstallers)ev.getServletContext().getAttribute(SYSTEM_SERVLET_CONTEXT_KEY);
        if (system != null) {
            LOG.info((Object)"calling system shutdown");
            system.shutdown();
        }
        ev.getServletContext().removeAttribute(SYSTEM_SERVLET_CONTEXT_KEY);
    }
}

