/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.http.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.nakedobjects.metamodel.commons.io.LazyInputStream;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.transport.TransportAbstract;

public class HttpClientTransport
extends TransportAbstract {
    private HttpClient httpClient;
    private String url;
    private ByteArrayOutputStream outputStream;
    private InputStream inputStream;

    public HttpClientTransport(NakedObjectConfiguration configuration) {
        super(configuration);
    }

    public void init() {
        this.httpClient = new HttpClient();
        this.url = this.getConfiguration().getString("nakedobjects.transport.http.url", "http://localhost:8080/remoting.svc");
    }

    public void shutdown() {
        this.httpClient = null;
    }

    public void connect() throws IOException {
        this.outputStream = new ByteArrayOutputStream();
    }

    public void disconnect() {
        this.inputStream = null;
        this.outputStream = null;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new LazyInputStream(new LazyInputStream.InputStreamProvider(){

                public InputStream getInputStream() throws IOException {
                    PostMethod postMethod = new PostMethod(HttpClientTransport.this.url);
                    InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(HttpClientTransport.this.outputStream.toByteArray()));
                    postMethod.setRequestEntity((RequestEntity)requestEntity);
                    HttpClientTransport.this.httpClient.executeMethod((HttpMethod)postMethod);
                    HttpClientTransport.this.outputStream.reset();
                    return postMethod.getResponseBodyAsStream();
                }
            });
        }
        return this.inputStream;
    }
}

