package org.nakedobjects.plugins.remoting.client.authorization;

import java.util.HashMap;
import java.util.Map;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.runtime.authorization.AuthorisationManager;


public class ProxyAuthorisationManager implements AuthorisationManager {

    private final ServerFacade connection;
    private final Map editableCache = new HashMap();
    private final Map visibleCache = new HashMap();

    public ProxyAuthorisationManager(final ServerFacade connection) {
        this.connection = connection;
    }

    private boolean remoteAuthUsability(final AuthenticationSession session, final String idString) {
        return connection.authoriseUsability(session, idString);
    }

    private boolean remoteAuthVisibility(final AuthenticationSession session, final String idString) {
        return connection.authoriseVisibility(session, idString);
    }

    private boolean isAuthorised(final AuthenticationSession session, final Identifier identifier, final Map cache) {
        final String idString = identifier.toIdentityString(Identifier.CLASS_NAME_PARMS);
        if (!cache.containsKey(idString)) {
            final boolean allow = cache == editableCache ? remoteAuthUsability(session, idString) : remoteAuthVisibility(session,
                    idString);
            cache.put(idString, new Boolean(allow));
            return allow;
        }
        return ((Boolean) cache.get(idString)).booleanValue();
    }

    public boolean isUsable(final AuthenticationSession session, final Identifier identifier) {
        return isAuthorised(session, identifier, editableCache);
    }

    public boolean isVisible(final AuthenticationSession session, final Identifier identifier) {
        return isAuthorised(session, identifier, visibleCache);
    }

    public void init() {}

    public void shutdown() {}
}
