package org.nakedobjects.plugins.remoting.client.facets;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacetAbstract;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;


/**
 * A reflection peer for changing one-to-many fields remotely, instead of on the local machine.
 * 
 * <p>
 * Any requests to add or remove elements from the field will be passed over the network to the server for
 * completion. Only requests on persistent objects are passed to the server; on a transient object the request
 * will always be dealt with locally.
 * 
 * <p>
 * If any of the objects involved have been changed on the server by another process then a
 * {@link ConcurrencyException} will be passed back to the client and re-thrown.
 * </p>
 */
final class PropertyClearFacetWrapProxy extends PropertyClearFacetAbstract implements DecoratingFacet<PropertyClearFacet> {

    private final ServerFacade connection;
    private final ObjectEncoder encoder;
    private final PropertyClearFacet underlyingFacet;
    private final String name;

    public PropertyClearFacetWrapProxy(
            final FacetHolder holder,
            final PropertyClearFacet underlyingFacet,
            final ServerFacade connection,
            final ObjectEncoder encoder,
            final String name) {
        super(holder);
        this.underlyingFacet = underlyingFacet;
        this.connection = connection;
        this.encoder = encoder;
        this.name = name;
    }

    public PropertyClearFacet getDecoratedFacet() {
        return underlyingFacet;
    }

    public void clearProperty(final NakedObject inObject) {
        if (ProxyUtil.executeRemotely(inObject)) {
            final IdentityData targetReference = encoder.createIdentityData(inObject);
            ObjectData[] updates;
            try {
                updates = connection.clearAssociation(NakedObjectsContext.getAuthenticationSession(), name, targetReference, encoder
                        .createIdentityData(null));
            } catch (final ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            ProxyUtil.updateChangedObjects(updates, encoder);
        } else {
            underlyingFacet.clearProperty(inObject);
        }
    }

}
// Copyright (c) Naked Objects Group Ltd.
