package org.nakedobjects.plugins.remoting.command.client.facetdecorator;


import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.nakedobjects.metamodel.commons.ensure.Ensure.ensureThatArg;

import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.plugins.remoting.client.authentication.AuthenticationManagerProxy;
import org.nakedobjects.plugins.remoting.client.authorization.ProxyAuthorisationFacetDecorator;
import org.nakedobjects.plugins.remoting.client.facetdecorator.ProxyFacetDecoratorFromRemotingCommandProject;
import org.nakedobjects.plugins.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.plugins.remoting.client.persistence.PersistenceSessionProxy;
import org.nakedobjects.plugins.remoting.client.persistence.ProxyPersistenceSessionFactory;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoder;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderImpl;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.DataFactoryImpl;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authorization.AuthorisationFacetDecorator;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstallerAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerProxy;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.objectstore.PersistenceSessionObjectStore;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;


public abstract class ProxyDecoratorInstallerAbstract extends PersistenceMechanismInstallerAbstract implements ClientConnectionInstaller {
    
    private static final Logger LOG = Logger.getLogger(ProxyDecoratorInstallerAbstract.class);
    
    public static final String ENCODER_CLASS_NAME_LIST = ConfigurationConstants.ROOT + "criteria.encoders";
    
    private ServerFacade serverFacade;
    private ObjectEncoderImpl encoder;

    
    ///////////////////////////////////////////////////////////////////
    // ServerFacade, RemoteProperties
    ///////////////////////////////////////////////////////////////////

    private ServerFacade getServerFacade() {
        if (serverFacade == null) {
            serverFacade = createServerFacade();
            serverFacade.init();
        }
        return serverFacade;
    }

    /**
     * Hook method called by {@link #getServerFacade()} as required.
     */
    protected abstract ServerFacade createServerFacade();


    public Properties getRemoteProperties() {
        // TODO sort out somewhere for properties to be accessed and then use them here
//        return getServerFacade().getProperties();
        return new Properties();
    }

    ///////////////////////////////////////////////////////////////////
    // Encoders
    ///////////////////////////////////////////////////////////////////

    public void installEncoders(final NakedObjectConfiguration configuration) {
        String[] encoders = configuration.getList(ENCODER_CLASS_NAME_LIST);
        final ObjectEncoderImpl encoder = getEncoder();
        for (int i = 0; i < encoders.length; i++) {
            final CriteriaEncoder encoding = InstanceFactory.createInstance(encoders[i], CriteriaEncoder.class);
            encoder.addCriteriaStrategy(encoding);
        }
    }

    protected ObjectEncoderImpl getEncoder() {
        if (encoder == null) {
            encoder = new ObjectEncoderImpl();
            encoder.setDataFactory(new DataFactoryImpl());
        }
        return encoder;
    }

    ///////////////////////////////////////////////////////////////////
    // AuthenticationManager
    ///////////////////////////////////////////////////////////////////

    public AuthenticationManager createAuthenticationManager() {
        return new AuthenticationManagerProxy(getServerFacade());
    }
    

    ///////////////////////////////////////////////////////////////////
    // Decorator 
    ///////////////////////////////////////////////////////////////////

    public FacetDecorator createDecorator() {
        final ServerFacade connection = getServerFacade();
        final ObjectEncoder encoder = getEncoder();

        final AuthorisationFacetDecorator authorisationFacetDecorator = new ProxyAuthorisationFacetDecorator(connection);

        final ProxyFacetDecoratorFromRemotingCommandProject proxyFacetDecorator = 
            new ProxyFacetDecoratorFromRemotingCommandProject(connection, encoder, authorisationFacetDecorator);

        return proxyFacetDecorator;
    }

    ///////////////////////////////////////////////////////////////////
    // Create PersistenceSession
    ///////////////////////////////////////////////////////////////////

    public PersistenceSessionFactory createPersistenceSessionFactory(final DeploymentType deploymentType) {
        return new ProxyPersistenceSessionFactory(deploymentType, this);
    }


	protected PersistenceSession createPersistenceSession(
			final PersistenceSessionFactory persistenceSessionFactory,
			final AdapterManagerExtended adapterManager,
			final AdapterFactory<?> adapterFactory,
			final ObjectFactory objectFactory,
			final OidGenerator<?> oidGenerator,
			final ServicesInjector servicesInjector) {

        installEncoders(getConfiguration());

        final PersistenceSessionProxy persistenceSession = 
            new PersistenceSessionProxy(
                    persistenceSessionFactory, 
                    adapterFactory, objectFactory, servicesInjector, oidGenerator, adapterManager, 
                    getServerFacade(), getEncoder());

        NakedObjectTransactionManager transactionManager = 
            createTransactionManager(getConfiguration(), persistenceSession.getAdapterManager(), persistenceSession);
        
        ensureThatArg(persistenceSession, is(not(nullValue())));
        ensureThatArg(transactionManager, is(not(nullValue())));
        
        transactionManager.injectInto(persistenceSession);

        
        // ... and finally return
        return persistenceSession;
	}


    /**
     * Creates the {@link NakedObjectTransactionManager}, potentially
     * overriddable.
     * 
     * <p>
     * Called from {@link #createPersistenceSession(PersistenceSessionFactory)}.
     */
    protected NakedObjectTransactionManager createTransactionManager(
            final NakedObjectConfiguration configuration,
            final AdapterManagerProxy adapterManager, 
            final PersistenceSessionTransactionManagement transactionManagement) {
        return new ClientSideTransactionManager(adapterManager, transactionManagement, getServerFacade(), getEncoder());
    }



}
// Copyright (c) Naked Objects Group Ltd.
