package org.nakedobjects.plugins.remoting.command.server;

import java.io.IOException;

import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.remoting.command.shared.marshal.ServerMarshaller;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;

public class ServerConnectionImpl implements ServerConnection {

    private final ServerFacade server;
    private ServerMarshaller serverMarshaller;

    public ServerConnectionImpl(final ServerFacade server, final ServerMarshaller serverMarshaller) {
        this.server = server;
        this.serverMarshaller = serverMarshaller; 
    }

    public ServerFacade getServer() {
        return server;
    }

    protected ServerMarshaller getServerMarshaller() {
        return serverMarshaller;
    }

    public Request awaitRequest() throws IOException {
        return serverMarshaller.awaitRequest();
    }

    public void sendResponse(Object response) throws IOException {
        serverMarshaller.sendResponse(response);
    }

    public void sendError(NakedObjectException exception) throws IOException {
        serverMarshaller.sendError(exception);
    }


}
// Copyright (c) Naked Objects Group Ltd.
