package org.nakedobjects.plugins.remoting.command.transport.pipe.server;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.command.transport.pipe.shared.PipedConnection;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.command.shared.requests.Response;


public class PipedServer {
    private static final Logger LOG = Logger.getLogger(PipedServer.class);
    private ServerFacade facade;
    private PipedConnection communication;

    public synchronized void run() {
        while (true) {
            final Request request = communication.getRequest();
            LOG.debug("client request: " + request);
            try {
                request.execute(facade);
                final Response response = new Response(request);
                LOG.debug("server response: " + response);
                communication.setResponse(response);
            } catch (final RuntimeException e) {
                communication.setException(e);
            } catch (final Exception e) {
                LOG.error("failure during request", e);
            }
        }
    }

    public void setConnection(final PipedConnection communication) {
        this.communication = communication;
    }

    public void setFacade(final ServerFacade facade) {
        this.facade = facade;
    }
}
// Copyright (c) Naked Objects Group Ltd.
