package org.nakedobjects.plugins.remoting.shared;

import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public abstract class CriteriaEncoderAbstract implements CriteriaEncoder {

    public InstancesCriteria restore(final CriteriaData criteriaData, final ObjectEncoder encoder) {
        final NakedObjectSpecification specification = NakedObjectsContext.getSpecificationLoader().loadSpecification(
                criteriaData.getType());
        return doRestore(specification, criteriaData, encoder);
    }

    protected abstract InstancesCriteria doRestore(
            NakedObjectSpecification specification,
            CriteriaData criteriaData,
            ObjectEncoder encoder);
}

// Copyright (c) Naked Objects Group Ltd.
