package org.nakedobjects.plugins.remoting.shared;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaPattern;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaDataPattern;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;

public class CriteriaEncoderPattern extends CriteriaEncoderAbstract {

    public CriteriaData createData(final InstancesCriteria criteria, final ObjectEncoder encoder) {
        final InstancesCriteriaPattern patternCriteria = (InstancesCriteriaPattern) criteria;
        final NakedObject pattern = patternCriteria.getPattern();
        final ObjectData objectData = (ObjectData) encoder.createParameters(new NakedObjectSpecification[] { pattern
                .getSpecification() }, new NakedObject[] { pattern }, new KnownObjects())[0];
        return new CriteriaDataPattern(patternCriteria, objectData);
    }

    @Override
    protected InstancesCriteria doRestore(
            final NakedObjectSpecification specification,
            final CriteriaData criteriaData,
            final ObjectEncoder encoder) {
        final ObjectData patternData = ((CriteriaDataPattern) criteriaData).getPattern();
        final NakedObject patternObject = encoder.restore(patternData);
        return new InstancesCriteriaPattern(specification, patternObject);
    }

    public Class<?> getCriteriaClass() {
        return InstancesCriteriaPattern.class;
    }
}

// Copyright (c) Naked Objects Group Ltd.
