package org.nakedobjects.plugins.remoting.shared;

import java.util.Properties;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.component.ApplicationScopedComponent;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.data.ServerActionResultData;


/**
 * previously called <tt>Distribution</tt>.
 */
public interface ServerFacade extends ApplicationScopedComponent {
    // TODO remove the associate - clear the field without reference to its current state!
    ObjectData[] clearAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate);

    ObjectData[] clearValue(AuthenticationSession session, String fieldIdentifier, IdentityData target);

    ClientActionResultData executeClientAction(AuthenticationSession session, ReferenceData[] changes, int types[]);

    ServerActionResultData executeServerAction(
            AuthenticationSession session,
            String actionType,
            String actionIdentifier,
            ReferenceData target,
            Data[] parameters);

    ObjectData[] findInstances(AuthenticationSession session, CriteriaData criteria);

    ObjectData getObject(AuthenticationSession session, Oid oid, String specificationName);

    boolean hasInstances(AuthenticationSession session, String specificationName);

    IdentityData oidForService(AuthenticationSession session, String id);

    Data resolveField(AuthenticationSession session, IdentityData data, String fieldName);

    ObjectData resolveImmediately(AuthenticationSession session, IdentityData target);

    ObjectData[] setAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate);

    ObjectData[] setValue(AuthenticationSession session, String fieldIdentifier, IdentityData target, EncodeableObjectData value);

    Properties getProperties();

    AuthenticationSession authenticate(String data);

    boolean authoriseUsability(AuthenticationSession session, String data);

    boolean authoriseVisibility(AuthenticationSession session, String data);

    void closeSession(AuthenticationSession session);
}
// Copyright (c) Naked Objects Group Ltd.
