/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.client.authorization;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.runtime.authorization.AuthorisationManager;

public class ProxyAuthorisationManager
implements AuthorisationManager {
    private final ServerFacade connection;
    private final Map editableCache = new HashMap();
    private final Map visibleCache = new HashMap();

    public ProxyAuthorisationManager(ServerFacade connection) {
        this.connection = connection;
    }

    private boolean remoteAuthUsability(AuthenticationSession session, String idString) {
        return this.connection.authoriseUsability(session, idString);
    }

    private boolean remoteAuthVisibility(AuthenticationSession session, String idString) {
        return this.connection.authoriseVisibility(session, idString);
    }

    private boolean isAuthorised(AuthenticationSession session, Identifier identifier, Map cache) {
        String idString = identifier.toIdentityString(2);
        if (!cache.containsKey(idString)) {
            boolean allow = cache == this.editableCache ? this.remoteAuthUsability(session, idString) : this.remoteAuthVisibility(session, idString);
            cache.put(idString, new Boolean(allow));
            return allow;
        }
        return (Boolean)cache.get(idString);
    }

    public boolean isUsable(AuthenticationSession session, Identifier identifier) {
        return this.isAuthorised(session, identifier, this.editableCache);
    }

    public boolean isVisible(AuthenticationSession session, Identifier identifier) {
        return this.isAuthorised(session, identifier, this.visibleCache);
    }

    public void init() {
    }

    public void shutdown() {
    }
}

