/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.client.persistence;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.transaction.ClientSideTransaction;
import org.nakedobjects.plugins.remoting.shared.transaction.ClientTransactionEvent;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerProxy;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManagerAbstract;
import org.nakedobjects.runtime.transaction.PersistenceCommand;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSideTransactionManager
extends NakedObjectTransactionManagerAbstract<ClientSideTransaction> {
    static final Logger LOG = Logger.getLogger(ClientSideTransactionManager.class);
    private final AdapterManagerProxy adapterManager;
    private final PersistenceSessionTransactionManagement transactionManagement;
    private final ServerFacade connection;
    private final ObjectEncoder encoder;

    public ClientSideTransactionManager(AdapterManagerProxy adapterManager, PersistenceSessionTransactionManagement transactionManagement, ServerFacade connection, ObjectEncoder encoder) {
        this.adapterManager = adapterManager;
        this.transactionManagement = transactionManagement;
        this.connection = connection;
        this.encoder = encoder;
    }

    public void startTransaction() {
        this.ensureTransactionNotInProgress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"startTransaction");
        }
        this.transactionManagement.clearAllDirty();
        this.createTransaction();
    }

    protected ClientSideTransaction createTransaction(MessageBroker messageBroker, UpdateNotifier updateNotifier) {
        return new ClientSideTransaction((NakedObjectTransactionManager)this, messageBroker, updateNotifier);
    }

    public void addCommand(PersistenceCommand command) {
    }

    public boolean flushTransaction() {
        return false;
    }

    public void endTransaction() {
        this.ensureTransactionInProgress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"endTransaction");
        }
        if (((ClientSideTransaction)this.getTransaction()).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"  no transaction commands to process");
            }
        } else {
            this.endNonEmptyTransaction();
        }
        ((ClientSideTransaction)this.getTransaction()).commit();
    }

    private void endNonEmptyTransaction() {
        ClientActionResultData results;
        KnownObjects knownObjects = new KnownObjects();
        ClientTransactionEvent[] transactionEntries = ((ClientSideTransaction)this.getTransaction()).getEntries();
        ReferenceData[] data = this.asData(transactionEntries, knownObjects);
        int[] eventTypes = this.asEventTypes(transactionEntries);
        try {
            results = this.connection.executeClientAction(this.getAuthenticationSession(), data, eventTypes);
        }
        catch (ConcurrencyException e) {
            Oid oid;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("concurrency conflict: " + e.getMessage()));
            }
            if ((oid = e.getSource()) == null) {
                throw e;
            }
            NakedObject failedObject = this.transactionManagement.reload(oid);
            throw new ConcurrencyException("Object automatically reloaded: " + failedObject.getSpecification().getTitle(failedObject), (Throwable)e);
        }
        if (results != null) {
            this.handleResults(transactionEntries, results);
        }
    }

    private int[] asEventTypes(ClientTransactionEvent[] entries) {
        int numberOfEvents = entries.length;
        int[] types = new int[numberOfEvents];
        for (int i = 0; i < numberOfEvents; ++i) {
            types[i] = entries[i].getType();
        }
        return types;
    }

    private ReferenceData[] asData(ClientTransactionEvent[] entries, KnownObjects knownObjects) {
        int numberOfEvents = entries.length;
        ReferenceData[] data = new ReferenceData[numberOfEvents];
        block5: for (int i = 0; i < numberOfEvents; ++i) {
            switch (entries[i].getType()) {
                case 1: {
                    data[i] = this.encoder.createMakePersistentGraph(entries[i].getObject(), knownObjects);
                    continue block5;
                }
                case 2: {
                    data[i] = this.encoder.createGraphForChangedObject(entries[i].getObject(), knownObjects);
                    continue block5;
                }
                case 3: {
                    data[i] = this.encoder.createIdentityData(entries[i].getObject());
                }
            }
        }
        return data;
    }

    private void handleResults(ClientTransactionEvent[] entries, ClientActionResultData results) {
        int i;
        int numberOfEvents = entries.length;
        int[] eventTypes = this.asEventTypes(entries);
        ReferenceData[] persistedUpdates = results.getPersisted();
        Version[] changedVersions = results.getChanged();
        block7: for (int i2 = 0; i2 < numberOfEvents; ++i2) {
            switch (eventTypes[i2]) {
                case 1: {
                    ReferenceData update = persistedUpdates[i2];
                    Oid updatedOid = update.getOid();
                    this.adapterManager.remapUpdated(updatedOid);
                    NakedObject adapter = this.adapterManager.getAdapterFor(updatedOid);
                    adapter.changeState(ResolveState.RESOLVED);
                    entries[i2].getObject().setOptimisticLock(update.getVersion());
                    continue block7;
                }
                case 2: {
                    entries[i2].getObject().setOptimisticLock(changedVersions[i2]);
                    this.getUpdateNotifier().addChangedObject(entries[i2].getObject());
                }
            }
        }
        ObjectData[] updates = results.getUpdates();
        for (i = 0; i < updates.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("update " + updates[i].getOid()));
            }
            this.encoder.restore(updates[i]);
        }
        for (i = 0; i < numberOfEvents; ++i) {
            switch (eventTypes[i]) {
                case 3: {
                    this.getUpdateNotifier().addDisposedObject(entries[i].getObject());
                }
            }
        }
    }

    public void abortTransaction() {
        this.ensureTransactionInProgress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"abortTransaction");
        }
        ((ClientSideTransaction)this.getTransaction()).abort();
    }

    public void addMakePersistent(NakedObject object) {
        this.ensureTransactionInProgress();
        ((ClientSideTransaction)this.getTransaction()).addMakePersistent(object);
    }

    public void addObjectChanged(NakedObject object) {
        this.ensureTransactionInProgress();
        ((ClientSideTransaction)this.getTransaction()).addObjectChanged(object);
    }

    public void addDestroyObject(NakedObject object) {
        this.ensureTransactionInProgress();
        ((ClientSideTransaction)this.getTransaction()).addDestroyObject(object);
    }

    private AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

