/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.client.persistence;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSessionAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceSessionProxy
extends PersistenceSessionAbstract {
    static final Logger LOG = Logger.getLogger(PersistenceSessionProxy.class);
    private ServerFacade connection;
    private ObjectEncoder encoder;
    private final Hashtable cache = new Hashtable();
    private HashMap<String, Oid> services = new HashMap();

    public PersistenceSessionProxy(PersistenceSessionFactory persistenceSessionFactory, AdapterFactory<?> adapterFactory, ObjectFactory objectFactory, ServicesInjector containerInjector, OidGenerator oidGenerator, AdapterManagerExtended identityMap, ServerFacade distribution, ObjectEncoder encoder) {
        super(persistenceSessionFactory, adapterFactory, objectFactory, containerInjector, oidGenerator, identityMap);
        this.setConnection(distribution);
        this.setEncoder(encoder);
    }

    public void doOpen() {
        this.connection.init();
    }

    public void doClose() {
        this.connection.shutdown();
    }

    public boolean isFixturesInstalled() {
        return true;
    }

    public void objectChanged(NakedObject adapter) {
        if (adapter.isTransient()) {
            this.getUpdateNotifier().addChangedObject(adapter);
        }
        if (adapter.getResolveState().respondToChangesInPersistentObjects()) {
            this.getClientSideTransactionManager().addObjectChanged(adapter);
        }
    }

    public synchronized void destroyObject(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("destroyObject " + object));
        }
        this.getClientSideTransactionManager().addDestroyObject(object);
    }

    public synchronized void makePersistent(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("makePersistent " + object));
        }
        this.getClientSideTransactionManager().addMakePersistent(object);
    }

    protected NakedObject[] getInstances(InstancesCriteria criteria) {
        NakedObject collection;
        NakedObjectSpecification specification = criteria.getSpecification();
        LOG.debug((Object)("getInstances of " + specification + " with " + criteria));
        if (this.cache.containsKey(specification) && (collection = (NakedObject)this.cache.get(specification)).getSpecification().isCollection()) {
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            Vector<NakedObject> instances = new Vector<NakedObject>();
            for (NakedObject instance : facet.iterable(collection)) {
                if (!criteria.matches(instance)) continue;
                instances.addElement(instance);
            }
            return instances.toArray(new NakedObject[instances.size()]);
        }
        CriteriaData criteriaData = this.encoder.createCriteriaData(criteria);
        ObjectData[] instancesAsObjectData = this.connection.findInstances(this.getAuthenticationSession(), criteriaData);
        NakedObject[] instances = new NakedObject[instancesAsObjectData.length];
        for (int i = 0; i < instancesAsObjectData.length; ++i) {
            instances[i] = this.encoder.restore(instancesAsObjectData[i]);
        }
        this.clearAllDirty();
        return instances;
    }

    public boolean hasInstances(NakedObjectSpecification specification) {
        NakedObject collection;
        CollectionFacet facet;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hasInstances of " + specification));
        }
        if (this.cache.containsKey(specification) && (facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)(collection = (NakedObject)this.cache.get(specification)))) != null) {
            return facet.size(collection) > 0;
        }
        return this.connection.hasInstances(this.getAuthenticationSession(), specification.getFullName());
    }

    public synchronized NakedObject loadObject(Oid oid, NakedObjectSpecification hint) {
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        ObjectData data = this.connection.getObject(null, oid, hint.getFullName());
        return this.encoder.restore(data);
    }

    public void reload(NakedObject object) {
        IdentityData identityData = this.encoder.createIdentityData(object);
        ObjectData update = this.connection.resolveImmediately(this.getAuthenticationSession(), identityData);
        this.encoder.restore(update);
    }

    public synchronized void resolveImmediately(NakedObject object) {
        ResolveState resolveState = object.getResolveState();
        if (resolveState.canChangeTo(ResolveState.RESOLVING)) {
            Oid oid = object.getOid();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("resolve object (remotely from server)" + oid));
            }
            ObjectData data = this.connection.resolveImmediately(this.getAuthenticationSession(), this.encoder.createIdentityData(object));
            this.encoder.restore(data);
        }
    }

    public void resolveField(NakedObject objectAdapter, NakedObjectAssociation field) {
        if (field.getSpecification().isMutableAggregated()) {
            return;
        }
        NakedObject referenceAdapter = field.get(objectAdapter);
        if (referenceAdapter != null && referenceAdapter.getResolveState().isResolved()) {
            return;
        }
        if (referenceAdapter == null || !referenceAdapter.isPersistent()) {
            return;
        }
        LOG.info((Object)("resolve-eagerly on server " + objectAdapter + "/" + field.getId()));
        Data data = this.connection.resolveField(this.getAuthenticationSession(), this.encoder.createIdentityData(objectAdapter), field.getId());
        this.encoder.restore(data);
    }

    public Oid getOidForService(String name) {
        Oid oid = this.services.get(name);
        if (oid == null) {
            IdentityData data = this.connection.oidForService(this.getAuthenticationSession(), name);
            oid = data.getOid();
            this.registerService(name, oid);
        }
        return oid;
    }

    public void registerService(String name, Oid oid) {
        this.services.put(name, oid);
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendln("Connection", (Object)this.connection);
    }

    public String debugTitle() {
        return "Proxy Object Manager";
    }

    public void setCacheInstances(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(names[i]);
            this.cache.put(spec, Boolean.TRUE);
        }
    }

    public void setConnection(ServerFacade connection) {
        this.connection = connection;
    }

    public void setEncoder(ObjectEncoder factory) {
        this.encoder = factory;
    }

    private ClientSideTransactionManager getClientSideTransactionManager() {
        return (ClientSideTransactionManager)this.getTransactionManager();
    }

    private AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }

    private UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }
}

