/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.client;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.remoting.command.client.CommandClientConnection;
import org.nakedobjects.plugins.remoting.command.shared.requests.Authenticate;
import org.nakedobjects.plugins.remoting.command.shared.requests.AuthoriseUsability;
import org.nakedobjects.plugins.remoting.command.shared.requests.AuthoriseVisibility;
import org.nakedobjects.plugins.remoting.command.shared.requests.ClearAssociation;
import org.nakedobjects.plugins.remoting.command.shared.requests.ClearValue;
import org.nakedobjects.plugins.remoting.command.shared.requests.CloseSession;
import org.nakedobjects.plugins.remoting.command.shared.requests.ExecuteClientAction;
import org.nakedobjects.plugins.remoting.command.shared.requests.ExecuteServerAction;
import org.nakedobjects.plugins.remoting.command.shared.requests.FindInstances;
import org.nakedobjects.plugins.remoting.command.shared.requests.GetObject;
import org.nakedobjects.plugins.remoting.command.shared.requests.GetProperties;
import org.nakedobjects.plugins.remoting.command.shared.requests.HasInstances;
import org.nakedobjects.plugins.remoting.command.shared.requests.OidForService;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.command.shared.requests.Resolve;
import org.nakedobjects.plugins.remoting.command.shared.requests.ResolveField;
import org.nakedobjects.plugins.remoting.command.shared.requests.Response;
import org.nakedobjects.plugins.remoting.command.shared.requests.SetAssociation;
import org.nakedobjects.plugins.remoting.command.shared.requests.SetValue;
import org.nakedobjects.plugins.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.data.ServerActionResultData;

public class ServerFacadeProxy
implements ServerFacade {
    private static final Logger LOG = Logger.getLogger(ServerFacadeProxy.class);
    private CommandClientConnection connection;

    public void init() {
        this.connection.init();
    }

    public void shutdown() {
        this.connection.shutdown();
    }

    public void closeSession(AuthenticationSession session) {
        CloseSession request = new CloseSession(session);
        this.execute(request);
    }

    public AuthenticationSession authenticate(String data) {
        Authenticate request = new Authenticate(data);
        this.execute(request);
        return request.getSession();
    }

    public boolean authoriseUsability(AuthenticationSession session, String data) {
        AuthoriseUsability request = new AuthoriseUsability(session, data);
        this.execute(request);
        return request.getAuthorised();
    }

    public boolean authoriseVisibility(AuthenticationSession session, String data) {
        AuthoriseVisibility request = new AuthoriseVisibility(session, data);
        this.execute(request);
        return request.getAuthorised();
    }

    public ObjectData[] setAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate) {
        SetAssociation request = new SetAssociation(session, fieldIdentifier, target, associate);
        this.execute(request);
        return request.getChanges();
    }

    public ObjectData[] setValue(AuthenticationSession session, String fieldIdentifier, IdentityData target, EncodeableObjectData value) {
        SetValue request = new SetValue(session, fieldIdentifier, target, value);
        this.execute(request);
        return request.getChanges();
    }

    public ObjectData[] clearAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate) {
        ClearAssociation request = new ClearAssociation(session, fieldIdentifier, target, associate);
        this.execute(request);
        return request.getChanges();
    }

    public ObjectData[] clearValue(AuthenticationSession session, String fieldIdentifier, IdentityData target) {
        ClearValue request = new ClearValue(session, fieldIdentifier, target);
        this.execute(request);
        return request.getChanges();
    }

    public ServerActionResultData executeServerAction(AuthenticationSession session, String actionType, String actionIdentifier, ReferenceData target, Data[] parameters) {
        ExecuteServerAction request = new ExecuteServerAction(session, actionType, actionIdentifier, target, parameters);
        this.execute(request);
        return request.getActionResult();
    }

    public ClientActionResultData executeClientAction(AuthenticationSession session, ReferenceData[] data, int[] types) {
        ExecuteClientAction request = new ExecuteClientAction(session, data, types);
        this.execute(request);
        return request.getActionResult();
    }

    public ObjectData getObject(AuthenticationSession session, Oid oid, String specificationName) {
        GetObject request = new GetObject(session, oid, specificationName);
        this.execute(request);
        return request.getObject();
    }

    public ObjectData resolveImmediately(AuthenticationSession session, IdentityData target) {
        Resolve request = new Resolve(session, target);
        this.execute(request);
        return request.getUpdateData();
    }

    public Data resolveField(AuthenticationSession session, IdentityData target, String name) {
        ResolveField request = new ResolveField(session, target, name);
        this.execute(request);
        return request.getUpdateData();
    }

    public ObjectData[] findInstances(AuthenticationSession session, CriteriaData criteria) {
        FindInstances request = new FindInstances(session, criteria);
        this.execute(request);
        return request.getInstances();
    }

    public boolean hasInstances(AuthenticationSession session, String fullName) {
        HasInstances request = new HasInstances(session, fullName);
        this.execute(request);
        return request.getFlag();
    }

    public IdentityData oidForService(AuthenticationSession session, String id) {
        OidForService request = new OidForService(session, id);
        this.execute(request);
        return request.getData();
    }

    public Properties getProperties() {
        GetProperties request = new GetProperties();
        this.execute(request);
        return request.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Request request) {
        CommandClientConnection commandClientConnection = this.connection;
        synchronized (commandClientConnection) {
            Response response = this.connection.executeRemotely(request);
            if (request.getId() != response.getId()) {
                throw new NakedObjectsRemoteException("Response out of sequence with respect to the request: " + request.getId() + " & " + response.getId() + " respectively");
            }
            LOG.debug((Object)("response " + response));
            request.setResponse(response.getObject());
        }
    }

    protected final Response executeRemotely(Request request) {
        return null;
    }

    public void set_Connection(CommandClientConnection connection) {
        this.setConnection(connection);
    }

    public void setConnection(CommandClientConnection connection) {
        this.connection = connection;
    }
}

