/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.marshal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.DebugByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.DebugByteEncoder;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.remoting.command.shared.marshal.MarshallerAbstract;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;

public class EncodingMarshaller
extends MarshallerAbstract {
    private static final Logger LOG = Logger.getLogger(EncodingMarshaller.class);
    private ByteEncoder encoder;
    private ByteDecoder decoder;

    public void openStreams(InputStream input, OutputStream output) throws IOException {
        this.encoder = new DebugByteEncoder(output);
        this.decoder = new DebugByteDecoder(input);
    }

    public Object request(Request request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sending request " + request));
        }
        try {
            this.write(request);
        }
        catch (SocketException e) {
            this.getOwner().reconnect();
            this.write(request);
        }
        Object object = this.decoder.getObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("response received: " + object));
        }
        this.decoder.end();
        return object;
    }

    private void write(Request request) throws IOException {
        this.encoder.add(request.getClass().getName());
        request.encode(this.encoder);
        this.encoder.end();
    }

    public Request awaitRequest() throws IOException {
        Request request = (Request)this.decoder.getObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request received: " + request));
        }
        this.decoder.end();
        return request;
    }

    public void sendError(NakedObjectException exception) throws IOException {
        this.send((Object)exception);
    }

    public void sendResponse(Object response) throws IOException {
        this.send(response);
    }

    private void send(Object object) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send response: " + object));
        }
        this.encoder.add(object);
        this.encoder.end();
    }
}

