/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.transport.pipe.shared;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.context.NakedObjectsContextMultiUser;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;

public class NakedObjectsContextPipe
extends NakedObjectsContextMultiUser {
    private NakedObjectSession clientSession;
    private NakedObjectSession serverSession;
    private Thread server;

    public static NakedObjectsContext createInstance(NakedObjectSessionFactory sessionFactory) {
        return new NakedObjectsContextPipe(sessionFactory);
    }

    private NakedObjectsContextPipe(NakedObjectSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void setServer(Thread server) {
        this.server = server;
    }

    private boolean isCurrentThreadServer() {
        return Thread.currentThread() == this.server;
    }

    public NakedObjectSession getSessionInstance() {
        if (this.isCurrentThreadServer()) {
            return this.serverSession;
        }
        return this.clientSession;
    }

    public NakedObjectSession openSessionInstance(AuthenticationSession authenticationSession) {
        this.applySessionClosePolicy();
        NakedObjectSession newSession = this.getSessionFactoryInstance().openSession(authenticationSession);
        if (this.isCurrentThreadServer()) {
            this.serverSession = newSession;
        } else {
            this.clientSession = newSession;
        }
        return newSession;
    }

    public void closeAllSessionsInstance() {
    }

    public String[] allSessionIds() {
        return new String[]{this.clientSession.getId(), this.serverSession.getId()};
    }

    public String debugTitle() {
        return "Naked Objects (pipe) " + Thread.currentThread().getName();
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendln("Server thread", (Object)this.server);
    }

    protected NakedObjectSession getSessionInstance(String executionContextId) {
        return null;
    }
}

