/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.transport.socket.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.remoting.command.client.CommandClientConnection;
import org.nakedobjects.plugins.remoting.command.shared.marshal.ClientMarshaller;
import org.nakedobjects.plugins.remoting.command.shared.marshal.ClientMarshallerOwner;
import org.nakedobjects.plugins.remoting.command.shared.marshal.ConnectionException;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.command.shared.requests.Response;
import org.nakedobjects.plugins.remoting.command.transport.socket.shared.ProfilingInputStream;
import org.nakedobjects.plugins.remoting.command.transport.socket.shared.ProfilingOutputStream;
import org.nakedobjects.plugins.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

public class CommandClientConnectionImpl
implements CommandClientConnection,
ClientMarshallerOwner {
    private static final Logger LOG = Logger.getLogger(CommandClientConnectionImpl.class);
    private final ClientMarshaller marshaller;
    private Socket socket;
    private int port;
    private String host;
    private ProfilingOutputStream profilingOutputStream;
    private ProfilingInputStream profilingInputStream;
    private boolean keepAlive;
    private boolean debugging;

    public CommandClientConnectionImpl(ClientMarshaller marshaller) {
        this.marshaller = marshaller;
        this.marshaller.setClientOwner(this);
    }

    protected ClientMarshaller getMarshaller() {
        return this.marshaller;
    }

    protected boolean isDebugging() {
        return this.debugging;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void init() {
        this.port = this.getConfiguration().getInteger("nakedobjects.remoting.command.port", 9567);
        this.host = this.getConfiguration().getString("nakedobjects.remoting.command.address", "localhost");
        this.keepAlive = this.getConfiguration().getBoolean("nakedobjects.remote.keepalive", false);
        this.debugging = this.getConfiguration().getBoolean("nakedobjects.remote.debugging", true);
        LOG.info((Object)("connections will be made to " + this.host + " " + this.port));
    }

    public void shutdown() {
        this.disconnect();
    }

    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    private void connect() {
        if (this.socket == null) {
            try {
                this.socket = new Socket(this.host, this.port);
                InputStream input = this.socket.getInputStream();
                OutputStream output = this.socket.getOutputStream();
                if (this.isDebugging()) {
                    this.profilingOutputStream = new ProfilingOutputStream(output);
                    output = this.profilingOutputStream;
                    this.profilingInputStream = new ProfilingInputStream(input);
                    input = this.profilingInputStream;
                }
                this.openStreams(input, output);
                LOG.debug((Object)("connection established " + this.socket));
            }
            catch (MalformedURLException e) {
                throw new ConnectionException("Connection failure", e);
            }
            catch (UnknownHostException e) {
                throw new ConnectionException("Connection failure", e);
            }
            catch (ConnectException e) {
                throw new ConnectionException("Failed to connect to " + this.host + "/" + this.port, e);
            }
            catch (IOException e) {
                throw new ConnectionException("Connection failure", e);
            }
        }
    }

    private void openStreams(InputStream input, OutputStream output) throws IOException {
        this.marshaller.openStreams(input, output);
    }

    private void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                LOG.error((Object)"failed to close connection", (Throwable)e);
            }
        }
    }

    public Response executeRemotely(Request request) {
        Object response;
        this.connect();
        try {
            response = this.request(request);
            if (this.profilingOutputStream != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.profilingOutputStream.getSize() + " bytes sent in " + this.profilingOutputStream.getTime() + " seconds"));
                }
                this.profilingOutputStream.resetTimer();
            }
            if (this.profilingInputStream != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.profilingInputStream.getSize() + " bytes received in " + this.profilingInputStream.getTime() + " seconds"));
                }
                this.profilingInputStream.resetTimer();
            }
            if (!this.isKeepAlive()) {
                this.disconnect();
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw new ConnectionException("Failed request", e);
        }
        if (response instanceof ConcurrencyException) {
            throw (ConcurrencyException)((Object)response);
        }
        if (response instanceof Exception) {
            throw new NakedObjectsRemoteException("Exception occurred on server", (Throwable)response);
        }
        return (Response)response;
    }

    private Object request(Request request) throws IOException {
        return this.marshaller.request(request);
    }

    private NakedObjectConfiguration getConfiguration() {
        return NakedObjectsContext.getConfiguration();
    }
}

