/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.transport.socket.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.remoting.command.server.ServerConnection;
import org.nakedobjects.plugins.remoting.command.shared.marshal.ConnectionException;
import org.nakedobjects.plugins.remoting.command.transport.socket.server.Worker;
import org.nakedobjects.plugins.remoting.command.transport.socket.server.WorkerPool;
import org.nakedobjects.plugins.remoting.command.transport.socket.shared.ProfilingInputStream;
import org.nakedobjects.plugins.remoting.command.transport.socket.shared.ProfilingOutputStream;
import org.nakedobjects.plugins.remoting.server.ServerFacadeImpl;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderImpl;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.ServerFacadeLogger;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.remoting.ServerListener;

public abstract class ServerListenerAbstract
implements ServerListener,
DebugInfo {
    private static final Logger LOG = Logger.getLogger(ServerListenerAbstract.class);
    private ObjectEncoderImpl encoder;
    private AuthenticationManager authenticationManager;
    private ServerSocket socket;
    private WorkerPool workerPool;
    private Boolean shutdown = Boolean.FALSE;

    public void listen() {
        this.ensureDependenciesInjected();
        int port = this.getConfiguration().getInteger("server.port", 9567);
        this.workerPool = new WorkerPool(5);
        ServerFacadeImpl sdd = new ServerFacadeImpl(this.authenticationManager);
        sdd.setEncoder(this.encoder);
        ServerFacadeLogger sd = new ServerFacadeLogger(this.encoder, sdd);
        sd.init();
        this.socket = this.newServerSocket(port);
        LOG.info((Object)("listening for connection on " + this.socket));
        this.acceptAndHandleRequests(sd);
        this.shutdown();
    }

    private ServerSocket newServerSocket(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            LOG.info((Object)("nof listener started on " + socket));
            socket.setSoTimeout(1000);
            ServerSocket serverSocket = socket;
            return serverSocket;
        }
        catch (IOException e) {
            throw new NakedObjectException((Throwable)e);
        }
        finally {
            this.shutdown(this.socket);
        }
    }

    private void acceptAndHandleRequests(ServerFacade sd) {
        while (!this.isShutdown()) {
            try {
                Socket clientSocket = this.socket.accept();
                LOG.info((Object)("connection accepted from " + clientSocket.getInetAddress()));
                InputStream inputStream = clientSocket.getInputStream();
                OutputStream outputStream = clientSocket.getOutputStream();
                if (this.isDebugging()) {
                    inputStream = new ProfilingInputStream(inputStream);
                    outputStream = new ProfilingOutputStream(outputStream);
                }
                ServerConnection connection = this.createClientConnection(inputStream, outputStream, sd);
                Worker worker = this.workerPool.getWorker();
                worker.setConnection(connection);
            }
            catch (InterruptedIOException ignore) {
            }
            catch (IOException e) {
                LOG.warn((Object)"connection exception", (Throwable)e);
            }
            catch (ConnectionException e) {
                LOG.warn((Object)"connection exception", (Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.info((Object)"stopping listener");
        Boolean bl = this.shutdown;
        synchronized (bl) {
            this.shutdown = Boolean.TRUE;
        }
    }

    private void shutdown() {
        this.shutdown(this.socket);
        this.socket = null;
        this.shutdown(this.workerPool);
        this.workerPool = null;
    }

    private void shutdown(ServerSocket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
            LOG.info((Object)"socket closed");
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close listening socket", (Throwable)e);
        }
    }

    private void shutdown(WorkerPool workerPool) {
        if (workerPool == null) {
            return;
        }
        workerPool.shutdown();
        LOG.info((Object)"worker pool stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShutdown() {
        Boolean bl = this.shutdown;
        synchronized (bl) {
            return this.shutdown;
        }
    }

    protected abstract ServerConnection createClientConnection(InputStream var1, OutputStream var2, ServerFacade var3);

    public void debugData(DebugString debug) {
        debug.appendln("Listener on", (Object)this.socket.toString());
        debug.appendln("Workers", (Object)this.workerPool);
        this.workerPool.debug(debug);
    }

    public String debugTitle() {
        return "Server Listener";
    }

    private boolean isDebugging() {
        return true;
    }

    private void ensureDependenciesInjected() {
        Assert.assertNotNull((String)"Session manager needed", (Object)this.authenticationManager);
        Assert.assertNotNull((String)"Encoder needed", (Object)this.encoder);
    }

    public void setAuthenticationManager(AuthenticationManager sessionManager) {
        this.authenticationManager = sessionManager;
    }

    public void setEncoder(ObjectEncoderImpl encoder) {
        this.encoder = encoder;
    }

    private NakedObjectConfiguration getConfiguration() {
        return NakedObjectsContext.getConfiguration();
    }
}

