/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.shared;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderDataStructure;
import org.nakedobjects.plugins.remoting.shared.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.NullData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

class ObjectEncoderDeserializer {
    private static final Logger LOG = Logger.getLogger(ObjectEncoderDeserializer.class);
    private ObjectEncoderDataStructure dataStructure;

    ObjectEncoderDeserializer() {
    }

    public void setDataStructure(ObjectEncoderDataStructure dataStructure) {
        this.dataStructure = dataStructure;
    }

    public NakedObject restore(Data data) {
        if (data instanceof CollectionData) {
            return this.restoreCollection((CollectionData)data, new KnownObjects());
        }
        return this.restoreObject(data, new KnownObjects());
    }

    public NakedObject restore(Data data, KnownObjects knownObjects) {
        if (data instanceof CollectionData) {
            return this.restoreCollection((CollectionData)data, knownObjects);
        }
        return this.restoreObject(data, knownObjects);
    }

    private NakedObject restoreCollection(CollectionData data, KnownObjects knownObjects) {
        String collectionType = data.getType();
        NakedObjectSpecification collectionSpecification = this.getSpecificationLoader().loadSpecification(collectionType);
        NakedObject collection = this.getPersistenceSession().createInstance(collectionSpecification);
        if (data.getElements() == null) {
            LOG.debug((Object)"restoring empty collection");
            return collection;
        }
        ReferenceData[] elements = data.getElements();
        LOG.debug((Object)("restoring collection " + elements.length + " elements"));
        NakedObject[] initData = new NakedObject[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            NakedObject element = this.restoreObject(elements[i], knownObjects);
            LOG.debug((Object)("restoring collection element :" + element));
            initData[i] = element;
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        facet.init(collection, initData);
        return collection;
    }

    private NakedObject restoreObject(Data data, KnownObjects knownObjects) {
        if (data instanceof NullData) {
            return null;
        }
        if (data instanceof ObjectData) {
            return this.restoreObjectFromObject((ObjectData)data, knownObjects);
        }
        if (data instanceof IdentityData) {
            return this.restoreObjectFromIdentity((IdentityData)data, knownObjects);
        }
        if (data instanceof EncodeableObjectData) {
            return this.restoreEncodable((EncodeableObjectData)data);
        }
        throw new UnknownTypeException((Object)data);
    }

    private NakedObject restoreObjectFromIdentity(IdentityData data, KnownObjects knownObjects) {
        Oid oid = data.getOid();
        NakedObject object = this.getAdapterManager().getAdapterFor(oid);
        if (object == null) {
            NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(data.getType());
            object = this.getHydrator().recreateAdapter(oid, specification);
        }
        return object;
    }

    private NakedObject restoreObjectFromObject(ObjectData data, KnownObjects knownObjects) {
        if (knownObjects.containsKey(data)) {
            return knownObjects.get(data);
        }
        Oid oid = data.getOid();
        NakedObject object = this.getAdapterManager().getAdapterFor(oid);
        if (object != null) {
            this.updateLoadedObject(data, object, knownObjects);
        } else {
            object = oid.isTransient() ? this.restoreTransient(data, knownObjects) : this.restorePersistentObject(data, oid, knownObjects);
        }
        return object;
    }

    private NakedObject restoreTransient(ObjectData data, KnownObjects knownObjects) {
        NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(data.getType());
        NakedObject object = this.getHydrator().recreateAdapter(data.getOid(), specification);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("restore transient object " + object));
        }
        knownObjects.put(object, data);
        this.setUpFields(data, object, knownObjects);
        return object;
    }

    private NakedObject restorePersistentObject(ObjectData data, Oid oid, KnownObjects knownObjects) {
        NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(data.getType());
        NakedObject object = this.getHydrator().recreateAdapter(oid, specification);
        if (data.getFieldContent() != null) {
            object.setOptimisticLock(data.getVersion());
            ResolveState state = data.hasCompleteData() ? ResolveState.RESOLVING : ResolveState.RESOLVING_PART;
            LOG.debug((Object)("restoring existing object (" + state.name() + ") " + object));
            this.setupFields(data, object, state, knownObjects);
        }
        return object;
    }

    private NakedObject restoreEncodable(EncodeableObjectData encodeableObjectData) {
        NakedObject value;
        if (encodeableObjectData.getEncodedObjectData() == null) {
            value = null;
        } else {
            NakedObjectSpecification spec = this.getSpecificationLoader().loadSpecification(encodeableObjectData.getType());
            EncodeableFacet encoder = (EncodeableFacet)spec.getFacet(EncodeableFacet.class);
            value = encoder.fromEncodedString(encodeableObjectData.getEncodedObjectData());
        }
        return value;
    }

    private void updateLoadedObject(ObjectData data, NakedObject object, KnownObjects knownObjects) {
        if (data.getFieldContent() != null) {
            object.setOptimisticLock(data.getVersion());
            ResolveState state = this.nextState(object.getResolveState(), data.hasCompleteData());
            if (state != null) {
                LOG.debug((Object)("updating existing object (" + state.name() + ") " + object));
                this.setupFields(data, object, state, knownObjects);
                this.getUpdateNotifier().addChangedObject(object);
            }
        } else if (data.getVersion() == null || data.getVersion().different(object.getVersion())) {
            // empty if block
        }
    }

    private void setUpCollectionField(ObjectData parentData, NakedObject object, NakedObjectAssociation field, CollectionData content, KnownObjects knownObjects) {
        if (!content.hasAllElements()) {
            NakedObject collection = field.get(object);
            if (collection.getResolveState() != ResolveState.GHOST) {
                LOG.debug((Object)("No data for collection: " + field.getId()));
                if (object.getVersion().different(parentData.getVersion())) {
                    LOG.debug((Object)("clearing collection as versions differ: " + object.getVersion() + " " + parentData.getVersion()));
                    CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
                    facet.init(collection, new NakedObject[0]);
                    collection.changeState(ResolveState.GHOST);
                }
            }
            return;
        }
        int size = content.getElements().length;
        NakedObject[] elements = new NakedObject[size];
        for (int j = 0; j < elements.length; ++j) {
            elements[j] = this.restoreObject(content.getElements()[j], knownObjects);
            LOG.debug((Object)("adding element to " + field.getId() + ": " + elements[j]));
        }
        NakedObject col = field.get(object);
        ResolveState initialState = col.getResolveState();
        ResolveState state = this.nextState(initialState, content.hasAllElements());
        if (state != null) {
            PersistorUtil.start((NakedObject)col, (ResolveState)state);
            NakedObject collection = ((OneToManyAssociation)field).get(object);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            facet.init(collection, elements);
            PersistorUtil.end((NakedObject)col);
        } else {
            LOG.warn((Object)("not initialising collection " + col + " due to current state " + initialState));
        }
    }

    private void setupFields(ObjectData data, NakedObject object, ResolveState state, KnownObjects knownObjects) {
        if (object.getResolveState().isDeserializable(state)) {
            PersistorUtil.start((NakedObject)object, (ResolveState)state);
            this.setUpFields(data, object, knownObjects);
            PersistorUtil.end((NakedObject)object);
        }
    }

    private void setUpFields(ObjectData data, NakedObject object, KnownObjects knownObjects) {
        Data[] fieldContent = data.getFieldContent();
        if (fieldContent != null && fieldContent.length > 0) {
            NakedObjectAssociation[] fields = this.dataStructure.getFields(object.getSpecification());
            if (fields.length != fieldContent.length) {
                throw new NakedObjectsRemoteException("Data received for different number of fields; expected " + fields.length + ", but was " + fieldContent.length);
            }
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectAssociation field = fields[i];
                Data fieldData = fieldContent[i];
                if (fieldData == null || !field.isPersisted()) {
                    LOG.debug((Object)("no data for field " + field.getId()));
                    continue;
                }
                if (field.isOneToManyAssociation()) {
                    this.setUpCollectionField(data, object, field, (CollectionData)fieldData, knownObjects);
                    continue;
                }
                if (field.getSpecification().isEncodeable()) {
                    this.setUpEncodedField(object, (OneToOneAssociation)field, fieldData);
                    continue;
                }
                this.setUpReferenceField(object, (OneToOneAssociation)field, fieldData, knownObjects);
            }
        }
    }

    private void setUpReferenceField(NakedObject object, OneToOneAssociation field, Data data, KnownObjects knownObjects) {
        NakedObject associate = this.restoreObject(data, knownObjects);
        LOG.debug((Object)("setting association for field " + field.getId() + ": " + associate));
        field.initAssociation(object, associate);
    }

    private void setUpEncodedField(NakedObject object, OneToOneAssociation field, Data data) {
        if (data instanceof NullData) {
            field.initAssociation(object, null);
        } else {
            String value = ((EncodeableObjectData)data).getEncodedObjectData();
            EncodeableFacet encoder = (EncodeableFacet)field.getSpecification().getFacet(EncodeableFacet.class);
            NakedObject valueAdapter = encoder.fromEncodedString(value);
            LOG.debug((Object)("setting value for field " + field.getId() + ": " + valueAdapter));
            field.initAssociation(object, valueAdapter);
        }
    }

    public void madePersistent(NakedObject objectAdapter, ObjectData update) {
        Data[] fieldData;
        if (update == null) {
            return;
        }
        if (objectAdapter.isTransient() && objectAdapter.getSpecification().persistability() != Persistability.TRANSIENT) {
            this.getAdapterManager().getAdapterFor(update.getOid());
            objectAdapter.setOptimisticLock(update.getVersion());
            objectAdapter.changeState(ResolveState.RESOLVED);
        }
        if ((fieldData = update.getFieldContent()) == null) {
            return;
        }
        NakedObjectAssociation[] fields = this.dataStructure.getFields(objectAdapter.getSpecification());
        for (int i = 0; i < fieldData.length; ++i) {
            if (fieldData[i] == null) continue;
            if (fields[i].isOneToOneAssociation()) {
                NakedObject field = ((OneToOneAssociation)fields[i]).get(objectAdapter);
                ObjectData fieldContent = (ObjectData)update.getFieldContent()[i];
                if (field == null) continue;
                this.madePersistent(field, fieldContent);
                continue;
            }
            if (!fields[i].isOneToManyAssociation()) continue;
            CollectionData collectionData = (CollectionData)update.getFieldContent()[i];
            NakedObject collectionAdapter = fields[i].get(objectAdapter);
            if (!collectionAdapter.isPersistent()) {
                collectionAdapter.changeState(ResolveState.RESOLVED);
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collectionAdapter);
            Enumeration elements = facet.elements(collectionAdapter);
            for (int j = 0; j < collectionData.getElements().length; ++j) {
                NakedObject element = (NakedObject)elements.nextElement();
                if (!(collectionData.getElements()[j] instanceof ObjectData)) continue;
                ObjectData elementData = (ObjectData)collectionData.getElements()[j];
                this.madePersistent(element, elementData);
            }
        }
    }

    private ResolveState nextState(ResolveState initialState, boolean complete) {
        ResolveState state = null;
        if (initialState == ResolveState.RESOLVED) {
            state = ResolveState.UPDATING;
        } else if (initialState == ResolveState.GHOST || initialState == ResolveState.PART_RESOLVED) {
            state = complete ? ResolveState.RESOLVING : ResolveState.RESOLVING_PART;
        } else if (initialState == ResolveState.TRANSIENT) {
            state = ResolveState.SERIALIZING_TRANSIENT;
        }
        return state;
    }

    private SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    private PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }
}

