/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.shared;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoder;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoderAllInstances;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoderFindByTitle;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoderPattern;
import org.nakedobjects.plugins.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderDataStructure;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderDeserializer;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderSerializer;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.DataFactory;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.NullData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.data.ServerActionResultData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEncoderImpl
implements ObjectEncoder {
    private final ObjectEncoderSerializer encoder = new ObjectEncoderSerializer();
    private final ObjectEncoderDeserializer decoder = new ObjectEncoderDeserializer();
    private final ObjectEncoderDataStructure dataStructure = new ObjectEncoderDataStructure();
    private final Map criteriaStragies = new HashMap();
    private DataFactory factory;
    private int actionGraphDepth = 0;
    private int persistentGraphDepth = 100;
    private int updateGraphDepth = 1;

    public ObjectEncoderImpl() {
        this.encoder.setDataStructure(this.dataStructure);
        this.decoder.setDataStructure(this.dataStructure);
        this.addCriteriaStrategy(new CriteriaEncoderAllInstances());
        this.addCriteriaStrategy(new CriteriaEncoderFindByTitle());
        this.addCriteriaStrategy(new CriteriaEncoderPattern());
    }

    public void addCriteriaStrategy(CriteriaEncoder encoder) {
        this.criteriaStragies.put(encoder.getCriteriaClass(), encoder);
    }

    @Override
    public ReferenceData createActionTarget(NakedObject target, KnownObjects knownObjects) {
        return this.encoder.serializeObject(this.factory, target, this.actionGraphDepth, knownObjects);
    }

    @Override
    public ClientActionResultData createClientActionResult(ReferenceData[] madePersistent, Version[] changedVersion, ObjectData[] updates) {
        return this.factory.createClientActionResultData(madePersistent, changedVersion, updates);
    }

    @Override
    public final ObjectData createCompletePersistentGraph(NakedObject object) {
        return (ObjectData)this.encoder.serializeObject(this.factory, object, this.persistentGraphDepth, new KnownObjects());
    }

    @Override
    public CriteriaData createCriteriaData(InstancesCriteria criteria) {
        CriteriaEncoder strategy = this.findCriteriaEncoder(criteria.getClass());
        return strategy.createData(criteria, this);
    }

    @Override
    public Data createForResolveField(NakedObject adapter, String fieldName) {
        Oid oid = adapter.getOid();
        NakedObjectSpecification specification = adapter.getSpecification();
        String type = specification.getFullName();
        ResolveState resolveState = adapter.getResolveState();
        NakedObjectAssociation[] fields = this.getFieldOrder(specification);
        Data[] fieldContent = new Data[fields.length];
        PersistorUtil.start((NakedObject)adapter, (ResolveState)adapter.getResolveState().serializeFrom());
        KnownObjects knownObjects = new KnownObjects();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getId().equals(fieldName)) continue;
            NakedObject field = fields[i].get(adapter);
            if (field == null) {
                fieldContent[i] = this.factory.createNullData(fields[i].getSpecification().getFullName());
                break;
            }
            if (fields[i].getSpecification().isEncodeable()) {
                fieldContent[i] = this.encoder.serializeEncodeable(this.factory, field);
                break;
            }
            if (fields[i].isOneToManyAssociation()) {
                fieldContent[i] = this.encoder.serializeCollection(this.factory, field, this.persistentGraphDepth, knownObjects);
                break;
            }
            NakedObjectsContext.getPersistenceSession().resolveImmediately(field);
            fieldContent[i] = this.encoder.serializeObject(this.factory, field, this.persistentGraphDepth, knownObjects);
            break;
        }
        PersistorUtil.end((NakedObject)adapter);
        ObjectData data = this.factory.createObjectData(type, oid, resolveState.isResolved(), adapter.getVersion());
        data.setFieldContent(fieldContent);
        return data;
    }

    @Override
    public ObjectData createForUpdate(NakedObject object) {
        ResolveState resolveState = object.getResolveState();
        if (resolveState.isSerializing() || resolveState.isGhost()) {
            throw new NakedObjectsRemoteException("Illegal resolve state: " + object);
        }
        return (ObjectData)this.encoder.serializeObject(this.factory, object, this.updateGraphDepth, new KnownObjects());
    }

    @Override
    public ObjectData createGraphForChangedObject(NakedObject object, KnownObjects knownObjects) {
        return (ObjectData)this.encoder.serializeObject(this.factory, object, 1, knownObjects);
    }

    @Override
    public final IdentityData createIdentityData(NakedObject object) {
        Assert.assertNotNull((String)"OID needed for reference", (Object)object, (Object)object.getOid());
        return this.factory.createIdentityData(object.getSpecification().getFullName(), object.getOid(), object.getVersion());
    }

    private Data createMadePersistentCollection(CollectionData collectionData, NakedObject collection) {
        ReferenceData[] elementData = collectionData.getElements();
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Iterator elements = facet.iterator(collection);
        for (int i = 0; i < elementData.length; ++i) {
            NakedObject element = (NakedObject)elements.next();
            Oid oid = element.getOid();
            Assert.assertNotNull((Object)oid);
            elementData[i] = this.createMadePersistentGraph((ObjectData)elementData[i], element);
        }
        return collectionData;
    }

    @Override
    public ObjectData createMadePersistentGraph(ObjectData data, NakedObject object) {
        Oid objectsOid = object.getOid();
        Assert.assertNotNull((Object)objectsOid);
        if (objectsOid.hasPrevious()) {
            Version version = object.getVersion();
            String type = data.getType();
            ObjectData persistedData = this.factory.createObjectData(type, objectsOid, true, version);
            Data[] allContents = data.getFieldContent();
            if (allContents != null) {
                int contentLength = allContents.length;
                Data[] persistentContents = new Data[contentLength];
                NakedObjectAssociation[] fields = this.getFieldOrder(object.getSpecification());
                for (int i = 0; i < contentLength; ++i) {
                    NakedObject fieldReference;
                    Data fieldData = allContents[i];
                    if (fieldData instanceof NullData) {
                        persistentContents[i] = null;
                        continue;
                    }
                    if (fields[i].isOneToOneAssociation()) {
                        if (fieldData instanceof ObjectData) {
                            fieldReference = fields[i].get(object);
                            persistentContents[i] = this.createMadePersistentGraph((ObjectData)fieldData, fieldReference);
                            continue;
                        }
                        persistentContents[i] = null;
                        continue;
                    }
                    if (!fields[i].isOneToManyAssociation()) continue;
                    fieldReference = fields[i].get(object);
                    persistentContents[i] = this.createMadePersistentCollection((CollectionData)fieldData, fieldReference);
                }
                persistedData.setFieldContent(persistentContents);
            }
            return persistedData;
        }
        return null;
    }

    @Override
    public ObjectData createMakePersistentGraph(NakedObject adapter, KnownObjects knownObjects) {
        Assert.assertTrue((String)"transient", (boolean)adapter.isTransient());
        return (ObjectData)this.encoder.serializeObject(this.factory, adapter, 1, knownObjects);
    }

    private final Data createParameter(String type, NakedObject object, KnownObjects knownObjects) {
        if (object == null) {
            return this.factory.createNullData(type);
        }
        if (object.getSpecification().isObject()) {
            if (object.getSpecification().isEncodeable()) {
                return this.encoder.serializeEncodeable(this.factory, object);
            }
            NakedObject nakedObject = object;
            return this.encoder.serializeObject(this.factory, nakedObject, 0, knownObjects);
        }
        throw new UnknownTypeException((Object)object.getSpecification());
    }

    @Override
    public final Data[] createParameters(NakedObjectSpecification[] parameterTypes, NakedObject[] parameters, KnownObjects knownObjects) {
        Data[] parameterData = new Data[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            NakedObject parameter = parameters[i];
            String type = parameterTypes[i].getFullName();
            parameterData[i] = this.createParameter(type, parameter, knownObjects);
        }
        return parameterData;
    }

    @Override
    public ServerActionResultData createServerActionResult(NakedObject result, ObjectData[] updates, ReferenceData[] disposed, ObjectData persistedTarget, ObjectData[] persistedParameters, String[] messages, String[] warnings) {
        Data result1;
        if (result == null) {
            result1 = this.factory.createNullData("");
        } else if (result.getSpecification().isCollection()) {
            result1 = this.encoder.serializeCollection(this.factory, result, this.persistentGraphDepth, new KnownObjects());
        } else if (result.getSpecification().isObject()) {
            result1 = this.createCompletePersistentGraph(result);
        } else {
            throw new UnknownTypeException((Object)result);
        }
        return this.factory.createServerActionResultData(result1, updates, disposed, persistedTarget, persistedParameters, messages, warnings);
    }

    @Override
    public EncodeableObjectData createValue(NakedObject value) {
        return this.encoder.serializeEncodeable(this.factory, value);
    }

    public ObjectData createObject(NakedObject object) {
        return (ObjectData)this.encoder.serializeObject(this.factory, object, 0, new KnownObjects());
    }

    @Override
    public NakedObjectAssociation[] getFieldOrder(NakedObjectSpecification specification) {
        return this.dataStructure.getFields(specification);
    }

    @Override
    public void madePersistent(NakedObject target, ObjectData persistedTarget) {
        this.decoder.madePersistent(target, persistedTarget);
    }

    @Override
    public NakedObject restore(Data data) {
        return this.decoder.restore(data);
    }

    @Override
    public NakedObject restore(Data data, KnownObjects knownObjects) {
        return this.decoder.restore(data, knownObjects);
    }

    @Override
    public InstancesCriteria restoreCriteria(CriteriaData criteriaData) {
        Class<?> criteriaClass = criteriaData.getCriteriaClass();
        CriteriaEncoder strategy = this.findCriteriaEncoder(criteriaClass);
        return strategy.restore(criteriaData, this);
    }

    private CriteriaEncoder findCriteriaEncoder(Class<?> criteriaClass) {
        CriteriaEncoder strategy = (CriteriaEncoder)this.criteriaStragies.get(criteriaClass);
        if (strategy == null) {
            throw new NakedObjectsRemoteException("No encoding strategy for " + criteriaClass.getName());
        }
        return strategy;
    }

    public void set_ActionGraphDepth(int actionGraphDepth) {
        this.setActionGraphDepth(actionGraphDepth);
    }

    public void set_PersistentGraphDepth(int persistentGraphDepth) {
        this.setPersistentGraphDepth(persistentGraphDepth);
    }

    public void set_UpdateGraphDepth(int updateGraphDepth) {
        this.setUpdateGraphDepth(updateGraphDepth);
    }

    public void setActionGraphDepth(int actionGraphDepth) {
        this.actionGraphDepth = actionGraphDepth;
    }

    public void set_DataFactory(DataFactory factory) {
        this.setDataFactory(factory);
    }

    public void setDataFactory(DataFactory factory) {
        this.factory = factory;
    }

    public void setPersistentGraphDepth(int persistentGraphDepth) {
        this.persistentGraphDepth = persistentGraphDepth;
    }

    public void setUpdateGraphDepth(int updateGraphDepth) {
        this.updateGraphDepth = updateGraphDepth;
    }
}

