/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.shared;

import java.util.Enumeration;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderDataStructure;
import org.nakedobjects.plugins.remoting.shared.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.DataFactory;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.runtime.persistence.PersistorUtil;

final class ObjectEncoderSerializer {
    private ObjectEncoderDataStructure dataStructure;

    ObjectEncoderSerializer() {
    }

    public CollectionData serializeCollection(DataFactory factory, NakedObject collectionAdapter, int graphDepth, KnownObjects knownObjects) {
        ReferenceData[] elements;
        boolean hasAllElements;
        Oid oid = collectionAdapter.getOid();
        String collectionType = collectionAdapter.getSpecification().getFullName();
        TypeOfFacet typeOfFacet = (TypeOfFacet)collectionAdapter.getSpecification().getFacet(TypeOfFacet.class);
        if (typeOfFacet == null) {
            throw new NakedObjectException("No type of facet for collection " + collectionAdapter);
        }
        String elementType = typeOfFacet.value().getName();
        boolean bl = hasAllElements = collectionAdapter.isTransient() || collectionAdapter.getResolveState().isResolved();
        if (hasAllElements) {
            CollectionFacet collectionFacet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collectionAdapter);
            Enumeration e = collectionFacet.elements(collectionAdapter);
            elements = new ReferenceData[collectionFacet.size(collectionAdapter)];
            int i = 0;
            while (e.hasMoreElements()) {
                NakedObject element = (NakedObject)e.nextElement();
                elements[i++] = this.serializeObject(factory, element, graphDepth, knownObjects);
            }
        } else {
            elements = new ObjectData[]{};
        }
        return factory.createCollectionData(collectionType, elementType, oid, elements, hasAllElements, collectionAdapter.getVersion());
    }

    public final EncodeableObjectData serializeEncodeable(DataFactory factory, NakedObject object) {
        EncodeableFacet facet = (EncodeableFacet)object.getSpecification().getFacet(EncodeableFacet.class);
        return factory.createValueData(object.getSpecification().getFullName(), facet.toEncodedString(object));
    }

    public final ReferenceData serializeObject(DataFactory factory, NakedObject object, int depth, KnownObjects knownObjects) {
        Assert.assertNotNull((Object)object);
        return (ReferenceData)this.serializeObject2(factory, object, depth, knownObjects);
    }

    private final Data serializeObject2(DataFactory factory, NakedObject adapter, int graphDepth, KnownObjects knownObjects) {
        Assert.assertNotNull((Object)adapter);
        ResolveState resolveState = adapter.getResolveState();
        boolean isTransient = adapter.isTransient();
        if (!isTransient && (resolveState.isSerializing() || resolveState.isGhost() || graphDepth <= 0)) {
            Assert.assertNotNull((String)"OID needed for reference", (Object)adapter, (Object)adapter.getOid());
            return factory.createIdentityData(adapter.getSpecification().getFullName(), adapter.getOid(), adapter.getVersion());
        }
        if (isTransient && knownObjects.containsKey(adapter)) {
            return knownObjects.get(adapter);
        }
        boolean withCompleteData = resolveState == ResolveState.TRANSIENT || resolveState == ResolveState.RESOLVED;
        String type = adapter.getSpecification().getFullName();
        Oid oid = adapter.getOid();
        ObjectData data = factory.createObjectData(type, oid, withCompleteData, adapter.getVersion());
        if (isTransient) {
            knownObjects.put(adapter, data);
        }
        NakedObjectAssociation[] fields = this.dataStructure.getFields(adapter.getSpecification());
        Data[] fieldContent = new Data[fields.length];
        PersistorUtil.start((NakedObject)adapter, (ResolveState)adapter.getResolveState().serializeFrom());
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isPersisted()) continue;
            NakedObject field = fields[i].get(adapter);
            if (fields[i].getSpecification().isEncodeable()) {
                if (field == null) {
                    fieldContent[i] = factory.createNullData(fields[i].getSpecification().getFullName());
                    continue;
                }
                fieldContent[i] = this.serializeEncodeable(factory, field);
                continue;
            }
            if (fields[i].isOneToManyAssociation()) {
                fieldContent[i] = this.serializeCollection(factory, field, graphDepth - 1, knownObjects);
                continue;
            }
            if (fields[i].isOneToOneAssociation()) {
                if (field == null) {
                    fieldContent[i] = !withCompleteData ? null : factory.createNullData(fields[i].getSpecification().getFullName());
                    continue;
                }
                fieldContent[i] = this.serializeObject2(factory, field, graphDepth - 1, knownObjects);
                continue;
            }
            throw new UnknownTypeException((Object)fields[i]);
        }
        PersistorUtil.end((NakedObject)adapter);
        data.setFieldContent(fieldContent);
        return data;
    }

    public void setDataStructure(ObjectEncoderDataStructure dataStructure) {
        this.dataStructure = dataStructure;
    }
}

