/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.shared;

import java.util.Properties;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.logging.Logger;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.NullData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.data.ServerActionResultData;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ServerFacadeLogger
extends Logger
implements ServerFacade {
    private static String PADDING = "      ";
    private final ObjectEncoder encoder;
    private final ServerFacade decorated;

    public ServerFacadeLogger(ObjectEncoder encoder, ServerFacade decorated, String fileName) {
        super(fileName, false);
        this.encoder = encoder;
        this.decorated = decorated;
    }

    public ServerFacadeLogger(ObjectEncoder encoder, ServerFacade decorated) {
        this(encoder, decorated, null);
    }

    protected Class getDecoratedClass() {
        return this.decorated.getClass();
    }

    public void init() {
        this.decorated.init();
    }

    public void shutdown() {
        this.decorated.shutdown();
    }

    public AuthenticationSession authenticate(String data) {
        this.log("authenticate");
        return this.decorated.authenticate(data);
    }

    public boolean authoriseUsability(AuthenticationSession session, String data) {
        this.log("authoriseUsability");
        return this.decorated.authoriseUsability(session, data);
    }

    public boolean authoriseVisibility(AuthenticationSession session, String data) {
        this.log("authoriseVisibility");
        return this.decorated.authoriseVisibility(session, data);
    }

    public void closeSession(AuthenticationSession session) {
        this.log("close session " + session);
        this.decorated.closeSession(session);
    }

    public ObjectData[] setAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate) {
        this.log("set association " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "associate: " + this.dump(associate));
        Data[] changes = this.decorated.setAssociation(session, fieldIdentifier, target, associate);
        this.log("  <-- changes: " + this.dump(changes));
        return changes;
    }

    public ObjectData[] setValue(AuthenticationSession session, String fieldIdentifier, IdentityData target, EncodeableObjectData value) {
        this.log("set value " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "value: " + value);
        Data[] changes = this.decorated.setValue(session, fieldIdentifier, target, value);
        this.log("  <-- changes: " + this.dump(changes));
        return changes;
    }

    public ObjectData[] clearAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate) {
        this.log("clear association " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "associate: " + this.dump(associate));
        Data[] changes = this.decorated.clearAssociation(session, fieldIdentifier, target, associate);
        this.log("  <-- changes: " + this.dump(changes));
        return changes;
    }

    public ObjectData[] clearValue(AuthenticationSession session, String fieldIdentifier, IdentityData target) {
        this.log("clear value " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target));
        Data[] changes = this.decorated.clearValue(session, fieldIdentifier, target);
        this.log("  <-- changes: " + this.dump(changes));
        return changes;
    }

    public ServerActionResultData executeServerAction(AuthenticationSession session, String actionType, String actionIdentifier, ReferenceData target, Data[] parameters) {
        ServerActionResultData result;
        this.log("execute action " + actionIdentifier + "/" + actionType + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "parameters: " + this.dump(parameters));
        try {
            result = this.decorated.executeServerAction(session, actionType, actionIdentifier, target, parameters);
            this.log("  <-- returns: " + this.dump(result.getReturn()));
            this.log("  <-- persisted target: " + this.dump(result.getPersistedTarget()));
            this.log("  <-- persisted parameters: " + this.dump(result.getPersistedParameters()));
            this.log("  <-- updates: " + this.dump(result.getUpdates()));
            this.log("  <-- disposed: " + this.dump(result.getDisposed()));
        }
        catch (RuntimeException e) {
            this.log("  <-- exception: " + e.getClass().getName() + " " + e.getMessage());
            throw e;
        }
        return result;
    }

    public ClientActionResultData executeClientAction(AuthenticationSession session, ReferenceData[] data, int[] types) {
        Vector complete = new Vector();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            str.append(this.indentedNewLine());
            str.append("[");
            str.append(i + 1);
            str.append("] ");
            switch (types[i]) {
                case 1: {
                    str.append("persisted: ");
                    break;
                }
                case 2: {
                    str.append("changed: ");
                    break;
                }
                case 3: {
                    str.append("deleted: ");
                }
            }
            this.dump(str, data[i], 3, complete);
        }
        this.log("execute client action " + str);
        ClientActionResultData results = this.decorated.executeClientAction(session, data, types);
        complete = new Vector();
        str = new StringBuffer();
        ReferenceData[] persistedUpdates = results.getPersisted();
        Version[] changedVersions = results.getChanged();
        block10: for (int i = 0; i < persistedUpdates.length; ++i) {
            str.append(this.indentedNewLine());
            str.append("[");
            str.append(i + 1);
            str.append("] ");
            switch (types[i]) {
                case 1: {
                    str.append("persisted: ");
                    this.dump(str, persistedUpdates[i], 3, complete);
                    continue block10;
                }
                case 2: {
                    str.append("changed: ");
                    str.append(changedVersions[i]);
                }
            }
        }
        this.log(" <--- execute client action results" + str);
        return results;
    }

    public ObjectData getObject(AuthenticationSession session, Oid oid, String specificationName) {
        this.log("get object " + oid);
        ObjectData data = this.decorated.getObject(null, oid, specificationName);
        this.log(" <-- data: " + data);
        return data;
    }

    public Data resolveField(AuthenticationSession session, IdentityData data, String name) {
        this.log("resolve field " + name + " - " + this.dump(data));
        Data result = this.decorated.resolveField(session, data, name);
        this.log(" <-- data: " + this.dump(result));
        return result;
    }

    public ObjectData resolveImmediately(AuthenticationSession session, IdentityData target) {
        this.log("resolve immediately" + this.dump(target));
        ObjectData result = this.decorated.resolveImmediately(session, target);
        this.log("  <-- data: " + this.dump(result));
        return result;
    }

    public ObjectData[] findInstances(AuthenticationSession session, CriteriaData criteria) {
        this.log("find instances " + criteria);
        Data[] instances = this.decorated.findInstances(session, criteria);
        this.log(" <-- instances: " + this.dump(instances));
        return instances;
    }

    public boolean hasInstances(AuthenticationSession session, String fullName) {
        this.log("has instances " + fullName);
        boolean hasInstances = this.decorated.hasInstances(session, fullName);
        this.log(" <-- instances: " + (hasInstances ? "yes" : "no"));
        return hasInstances;
    }

    public Properties getProperties() {
        this.log("get properties");
        Properties properties = this.decorated.getProperties();
        this.log(" <-- data: " + properties);
        return properties;
    }

    public IdentityData oidForService(AuthenticationSession session, String id) {
        this.log("oid for resource " + id);
        IdentityData result = this.decorated.oidForService(session, id);
        this.log(" <-- data: " + this.dump(result));
        return result;
    }

    private String dump(Data data) {
        StringBuffer str = new StringBuffer();
        this.dump(str, data, 1, new Vector());
        return str.toString();
    }

    private String dump(Data[] data) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            str.append("\n    [");
            str.append(i + 1);
            str.append("] ");
            this.dump(str, data[i], 3, new Vector());
        }
        return str.toString();
    }

    private void dump(StringBuffer str, Data data, int indent, Vector complete) {
        if (data == null) {
            str.append("null");
        } else if (data instanceof NullData) {
            str.append("NULL (NullData object)");
        } else if (data instanceof EncodeableObjectData) {
            EncodeableObjectData encodeableObjectData = (EncodeableObjectData)data;
            str.append("ValueData@" + Integer.toHexString(encodeableObjectData.hashCode()) + " " + encodeableObjectData.getType() + ":" + encodeableObjectData.getEncodedObjectData());
        } else if (data instanceof IdentityData) {
            IdentityData referenceData = (IdentityData)data;
            str.append("ReferenceData@" + Integer.toHexString(referenceData.hashCode()) + " " + referenceData.getType() + ":" + referenceData.getOid() + ":" + referenceData.getVersion());
        } else if (data instanceof ObjectData) {
            this.dumpObjectData(str, data, indent, complete);
        } else if (data instanceof CollectionData) {
            this.dumpCollectionData(str, data, indent, complete);
        } else {
            str.append("Unknown: " + data);
        }
    }

    private void dumpCollectionData(StringBuffer str, Data data, int indent, Vector complete) {
        CollectionData objectData = (CollectionData)data;
        str.append("CollectionData@" + Integer.toHexString(objectData.hashCode()) + " " + objectData.getType() + ":" + objectData.getOid() + ":" + (objectData.hasAllElements() ? "A" : "-") + ":" + objectData.getVersion());
        ReferenceData[] elements = objectData.getElements();
        for (int i = 0; elements != null && i < elements.length; ++i) {
            str.append("\n");
            str.append(this.padding(indent));
            str.append(i + 1);
            str.append(") ");
            this.dump(str, elements[i], indent + 1, complete);
        }
    }

    private void dumpObjectData(StringBuffer str, Data data, int indent, Vector complete) {
        ObjectData objectData = (ObjectData)data;
        str.append("ObjectData@" + Integer.toHexString(objectData.hashCode()) + " " + objectData.getType() + ":" + objectData.getOid() + ":" + (objectData.hasCompleteData() ? "C" : "-") + ":" + objectData.getVersion());
        if (complete.contains(objectData)) {
            str.append(" (already detailed)");
            return;
        }
        complete.addElement(objectData);
        NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(data.getType());
        NakedObjectAssociation[] fs = this.encoder.getFieldOrder(spec);
        Data[] fields = objectData.getFieldContent();
        for (int i = 0; fields != null && i < fields.length; ++i) {
            str.append("\n");
            str.append(this.padding(indent));
            str.append(i + 1);
            str.append(") ");
            str.append(fs[i].getId());
            str.append(": ");
            this.dump(str, fields[i], indent + 1, complete);
        }
    }

    private String indentedNewLine() {
        return "\n" + this.padding(2);
    }

    private String padding(int indent) {
        int length = indent * 3;
        while (length > PADDING.length()) {
            PADDING = PADDING + PADDING;
        }
        return PADDING.substring(0, length);
    }
}

