/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.shared.data;

import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.remoting.shared.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;

public class CollectionDataImpl
implements CollectionData,
Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReferenceData[] elements;
    private final Oid oid;
    private final String collectionType;
    private final Version version;
    private final boolean hasAllElements;
    private final String elementType;

    public CollectionDataImpl(Oid oid, String collectionType, String elementType, ReferenceData[] elements, boolean hasAllElements, Version version) {
        this.oid = oid;
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.elements = elements;
        this.hasAllElements = hasAllElements;
        this.version = version;
    }

    public CollectionDataImpl(ByteDecoder decoder) {
        this.collectionType = decoder.getString();
        this.elementType = decoder.getString();
        this.oid = (Oid)decoder.getObject();
        this.version = (Version)decoder.getObject();
        this.hasAllElements = decoder.getBoolean();
        this.elements = (ReferenceData[])decoder.getObjects();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.collectionType);
        encoder.add(this.elementType);
        encoder.add((Object)this.oid);
        encoder.add((Object)this.version);
        encoder.add(this.hasAllElements);
        encoder.add((Object[])this.elements);
    }

    public ReferenceData[] getElements() {
        return this.elements;
    }

    public String getElementype() {
        return this.elementType;
    }

    public Oid getOid() {
        return this.oid;
    }

    public String getType() {
        return this.collectionType;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean hasAllElements() {
        return this.hasAllElements;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("collection type", this.collectionType);
        str.append("element type", this.elementType);
        str.append("oid", (Object)this.oid);
        str.append("version", (Object)this.version);
        str.append(",elements=");
        for (int i = 0; this.elements != null && i < this.elements.length; ++i) {
            if (i > 0) {
                str.append(";");
            }
            if (this.elements[i] == null) {
                str.append("null");
                continue;
            }
            String name = this.elements[i].getClass().getName();
            str.append(name.substring(name.lastIndexOf(46) + 1));
        }
        return str.toString();
    }
}

