package org.nakedobjects.plugins.remoting.command.shared.requests;

import java.io.Serializable;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;


public abstract class RequestAbstract implements Request, Serializable {
    private static int nextId = 0;
    protected transient Object response;
    private final int id;
    protected final AuthenticationSession session;

    public RequestAbstract(final AuthenticationSession session) {
        this.session = session;
        id = nextId++;
    }

    public RequestAbstract(final ByteDecoder decoder) {
        id = decoder.getInt();
        session = (AuthenticationSession) decoder.getObject();
    }

    public final void encode(final ByteEncoder encoder) {
        encoder.add(id);
        encoder.add(session);
        doEncode(encoder);
    }

    protected abstract void doEncode(ByteEncoder encoder);

    public final void setResponse(final Object response) {
        this.response = response;
    }

    public Object getResponse() {
        return response;
    }

    public AuthenticationSession getSession() {
        return session;
    }

    public int getId() {
        return id;
    }
}
// Copyright (c) Naked Objects Group Ltd.
