package org.nakedobjects.plugins.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;

public class SetValue extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String fieldIdentifier;
    private final EncodeableObjectData value;
    private final IdentityData target;

    public SetValue(
            final AuthenticationSession session,
            final String fieldIdentifier,
            final IdentityData target,
            final EncodeableObjectData value) {
        super(session);
        this.fieldIdentifier = fieldIdentifier;
        this.target = target;
        this.value = value;
    }

    public SetValue(final ByteDecoder decoder) {
        super(decoder);
        fieldIdentifier = decoder.getString();
        target = (IdentityData) decoder.getObject();
        value = (EncodeableObjectData) decoder.getObject();
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(fieldIdentifier);
        encoder.add(target);
        encoder.add(value);
    }

    public void execute(final ServerFacade distribution) {
        response = distribution.setValue(session, fieldIdentifier, target, value);
    }

    public ObjectData[] getChanges() {
        return (ObjectData[]) response;
    }
}
// Copyright (c) Naked Objects Group Ltd.
