package org.nakedobjects.plugins.remoting.command.transport.socket.server;

import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoder;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoderImpl;
import org.nakedobjects.plugins.remoting.shared.data.DataFactoryImpl;
import org.nakedobjects.runtime.installers.InstallerAbstract;
import org.nakedobjects.runtime.remoting.ServerListener;
import org.nakedobjects.runtime.remoting.ServerListenerInstaller;

public abstract class ServerListenerInstallerAbstract extends InstallerAbstract implements ServerListenerInstaller {

    protected abstract ServerListenerAbstract createListenerInstance();

    public ServerListener createListener() {

        final ServerListenerAbstract serverListener = createListenerInstance();
        serverListener.setEncoder(createEncoder(getConfiguration()));

        return serverListener;
    }

    private ObjectEncoderImpl createEncoder(final NakedObjectConfiguration configuration) {
        final ObjectEncoderImpl encoder = new ObjectEncoderImpl();
        encoder.setDataFactory(new DataFactoryImpl());

        String[] encoders = configuration.getList(ConfigurationConstants.ROOT + "criteria.encoders");
        for (int i = 0; i < encoders.length; i++) {
            final CriteriaEncoder encoding = InstanceFactory.createInstance(encoders[i], CriteriaEncoder.class);
            encoder.addCriteriaStrategy(encoding);
        }

        return encoder;
    }


}
