package org.nakedobjects.plugins.remoting.shared;

import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaAllInstances;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaDataAllInstances;

public class CriteriaEncoderAllInstances extends CriteriaEncoderAbstract {

    public CriteriaData createData(final InstancesCriteria criteria, final ObjectEncoder objectEncoder) {
        return new CriteriaDataAllInstances((InstancesCriteriaAllInstances) criteria);
    }

    @Override
    protected InstancesCriteria doRestore(
            final NakedObjectSpecification specification,
            final CriteriaData criteriaData,
            final ObjectEncoder encoder) {
        return new InstancesCriteriaAllInstances(specification);
    }

    public Class<?> getCriteriaClass() {
        return InstancesCriteriaAllInstances.class;
    }
}

// Copyright (c) Naked Objects Group Ltd.
