package org.nakedobjects.plugins.remoting.shared;

import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaTitle;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaDataFindByTitle;

public class CriteriaEncoderFindByTitle extends CriteriaEncoderAbstract {

    public CriteriaData createData(final InstancesCriteria criteria, final ObjectEncoder objectEncoder) {
        return new CriteriaDataFindByTitle((InstancesCriteriaTitle) criteria);
    }

    @Override
    protected InstancesCriteria doRestore(
            final NakedObjectSpecification specification,
            final CriteriaData criteriaData,
            final ObjectEncoder encoder) {
        final String title = ((CriteriaDataFindByTitle) criteriaData).getTitle();
        return new InstancesCriteriaTitle(specification, title);
    }

    public Class<?> getCriteriaClass() {
        return InstancesCriteriaTitle.class;
    }
}

// Copyright (c) Naked Objects Group Ltd.
