package org.nakedobjects.plugins.remoting.shared;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.data.ServerActionResultData;


public interface ObjectEncoder {

    //////////////////////////////////////////////////
    // Identity
    //////////////////////////////////////////////////
    
    IdentityData createIdentityData(NakedObject object);


    //////////////////////////////////////////////////
    // restore
    //////////////////////////////////////////////////

    NakedObject restore(Data returned);

    NakedObject restore(Data data, KnownObjects knownObjects);

    
    //////////////////////////////////////////////////
    // Resolves
    //////////////////////////////////////////////////

    Data createForResolveField(NakedObject object, String fieldName);

    
    
    //////////////////////////////////////////////////
    // Actions & Parameters
    //////////////////////////////////////////////////

    ReferenceData createActionTarget(NakedObject target, KnownObjects knownObjects);

    Data[] createParameters(NakedObjectSpecification[] parameterTypes, NakedObject[] parameters, KnownObjects knownObjects);


    ServerActionResultData createServerActionResult(
            NakedObject result,
            ObjectData[] updates,
            ReferenceData[] disposed,
            ObjectData persistedTarget,
            ObjectData[] persistedParameters,
            String[] messages,
            String[] warnings);

    ClientActionResultData createClientActionResult(ReferenceData[] madePersistent, Version[] changedVersion, ObjectData[] updates);


    //////////////////////////////////////////////////
    // Graphs
    //////////////////////////////////////////////////

    /**
     * Creates an {@link ObjectData} that contains all the data for all the transient objects in the specified
     * transient object.
     * 
     * <p>
     * For any referenced persistent object in the graph, only the reference is passed across.
     */
    ObjectData createMakePersistentGraph(NakedObject object, KnownObjects knownObjects);

    ObjectData createGraphForChangedObject(NakedObject object, KnownObjects knownObjects);

    /**
     * Creates a a graph of ReferenceData objects (mirroring the graph of transient objects) to transfer the
     * OIDs and Versions for each object that was made persistent during the makePersistent call.
     */
    ObjectData createMadePersistentGraph(ObjectData data, NakedObject object);

    /**
     * Creates an ObjectData that contains all the data for all the objects in the graph. This allows the
     * client to receive all data it might need without having to return to the server to get referenced
     * objects.
     */
    ObjectData createCompletePersistentGraph(NakedObject object);

    
    //////////////////////////////////////////////////
    // makePersistent
    //////////////////////////////////////////////////

    void madePersistent(NakedObject target, ObjectData persistedTarget);


    //////////////////////////////////////////////////
    // Criteria
    //////////////////////////////////////////////////

    CriteriaData createCriteriaData(InstancesCriteria criteria);

    InstancesCriteria restoreCriteria(CriteriaData criteriaData);
    


    //////////////////////////////////////////////////
    // Value
    //////////////////////////////////////////////////

    EncodeableObjectData createValue(NakedObject value);

    //////////////////////////////////////////////////
    // Update
    //////////////////////////////////////////////////

    /**
     * Creates an {@link ObjectData} that contains the data for the specified object, but not the data for any
     * referenced objects.
     * 
     * <p>
     * For each referenced object only the reference is passed across.
     */
    ObjectData createForUpdate(NakedObject object);


    //////////////////////////////////////////////////
    // Field Order
    //////////////////////////////////////////////////

    /**
     * Returns the agreed order to transfer fields within data objects. Both remote parties need to process
     * the fields in the same order, this is that order.
     */
    NakedObjectAssociation[] getFieldOrder(NakedObjectSpecification specification);


}

// Copyright (c) Naked Objects Group Ltd.
