/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.server;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.hamcrest.CoreMatchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.remoting.server.ServerFacadeImpl;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.DummyClientResultData;
import org.nakedobjects.plugins.remoting.shared.data.DummyIdentityData;
import org.nakedobjects.plugins.remoting.shared.data.DummyObjectData;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.data.ReferenceData;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxySession;
import org.nakedobjects.runtime.testsystem.TestProxySystem;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

@RunWith(value=JMock.class)
public class ServerDistributionClientActionTest {
    private Mockery mockery = new JUnit4Mockery();
    private AuthenticationManager mockAuthenticationManager;
    private ObjectEncoder mockEncoder;
    private ServerFacadeImpl server;
    private AuthenticationSession session;
    private TestProxySystem system;

    @Before
    public void setUp() throws Exception {
        BasicConfigurator.configure();
        LogManager.getRootLogger().setLevel(Level.OFF);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockEncoder = (ObjectEncoder)this.mockery.mock(ObjectEncoder.class);
        this.server = new ServerFacadeImpl(this.mockAuthenticationManager);
        this.server.setEncoder(this.mockEncoder);
        this.server.init();
        this.system = new TestProxySystem();
        this.system.init();
        this.session = NakedObjectsContext.getAuthenticationSession();
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testExecuteClientActionWithNoWork() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).createClientActionResult((ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (Version[])this.with(CoreMatchers.equalTo((Object)new Version[0])), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])));
                this.will(1.returnValue((Object)new DummyClientResultData((ReferenceData[])new ObjectData[0], new Version[0], null)));
            }
        });
        ClientActionResultData result = this.server.executeClientAction(this.session, new ReferenceData[0], new int[0]);
        Assert.assertEquals((long)0L, (long)result.getPersisted().length);
        Assert.assertEquals((long)0L, (long)result.getChanged().length);
    }

    @Test
    public void testExecuteClientActionWhereObjectChanged() {
        final NakedObject adapter = this.system.createPersistentTestObject();
        final DummyObjectData data = new DummyObjectData(adapter.getOid(), "none", true, (Version)new TestProxyVersion(1));
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).restore((Data)data, new KnownObjects());
                this.will(2.returnValue((Object)adapter));
            }
        });
        final DummyClientResultData results = new DummyClientResultData((ReferenceData[])new ObjectData[0], new Version[0], null);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).createClientActionResult((ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[1])), (Version[])this.with(CoreMatchers.equalTo((Object)new Version[]{new TestProxyVersion(2)})), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])));
                this.will(3.returnValue((Object)results));
            }
        });
        ClientActionResultData result = this.server.executeClientAction(this.session, new ReferenceData[]{data}, new int[]{2});
        NakedObject object = NakedObjectsContext.getPersistenceSession().loadObject(adapter.getOid(), adapter.getSpecification());
        Assert.assertEquals((Object)new TestProxyVersion(2), (Object)object.getVersion());
        Assert.assertEquals((Object)results, (Object)result);
    }

    @Test
    public void testExecuteClientActionWhereObjectMadePersistent() {
        final NakedObject adapter = this.system.createTransientTestObject();
        final DummyObjectData data = new DummyObjectData(adapter.getOid(), "none", true, (Version)new TestProxyVersion(1));
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).restore((Data)data, new KnownObjects());
                this.will(4.returnValue((Object)adapter));
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).createIdentityData(adapter);
                this.will(4.returnValue(null));
            }
        });
        final DummyClientResultData results = new DummyClientResultData((ReferenceData[])new ObjectData[0], new Version[0], new ObjectData[0]);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).createClientActionResult((ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[1])), (Version[])this.with(CoreMatchers.equalTo((Object)new Version[1])), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])));
                this.will(5.returnValue((Object)results));
            }
        });
        ClientActionResultData result = this.server.executeClientAction(this.session, new ReferenceData[]{data}, new int[]{1});
        NakedObject object = NakedObjectsContext.getPersistenceSession().loadObject(adapter.getOid(), adapter.getSpecification());
        Assert.assertEquals((Object)results, (Object)result);
        Assert.assertEquals((Object)adapter, (Object)object);
        Assert.assertEquals((Object)new TestProxyVersion(1), (Object)object.getVersion());
    }

    @Test
    public void testExecuteClientActionFailsWithConcurrencyError() {
        NakedObject adapter = this.system.createPersistentTestObject();
        adapter.setOptimisticLock((Version)new TestProxyVersion(7));
        Oid oid = adapter.getOid();
        DummyIdentityData identityData = new DummyIdentityData(oid, TestProxyNakedObject.class.getName(), (Version)new TestProxyVersion(6));
        try {
            this.server.executeClientAction((AuthenticationSession)new TestProxySession(), new ReferenceData[]{identityData}, new int[]{3});
            Assert.fail();
        }
        catch (ConcurrencyException expected) {
            // empty catch block
        }
    }

    @Test
    public void testExecuteClientActionWhereObjectDeleted() {
        NakedObject adapter = this.system.createPersistentTestObject();
        Oid oid = adapter.getOid();
        DummyIdentityData identityData = new DummyIdentityData(oid, TestProxyNakedObject.class.getName(), (Version)new TestProxyVersion(1));
        final DummyClientResultData results = new DummyClientResultData((ReferenceData[])new ObjectData[0], new Version[0], null);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoder)this.one(ServerDistributionClientActionTest.this.mockEncoder)).createClientActionResult((ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[1])), (Version[])this.with(CoreMatchers.equalTo((Object)new Version[1])), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])));
                this.will(6.returnValue((Object)results));
            }
        });
        ClientActionResultData result = this.server.executeClientAction((AuthenticationSession)new TestProxySession(), new ReferenceData[]{identityData}, new int[]{3});
        Assert.assertEquals((Object)results, (Object)result);
    }
}

