/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.server;

import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.plugins.remoting.server.ServerFacadeImpl;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.data.DummyReferenceData;
import org.nakedobjects.plugins.remoting.shared.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.data.ObjectData;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.testsystem.ProxyJunit4TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyAssociation;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

@RunWith(value=JMock.class)
public class ServerDistribution_AssociationTest
extends ProxyJunit4TestCase {
    private Mockery mockery = new JUnit4Mockery();
    private ServerFacadeImpl server;
    private AuthenticationSession authenticationSession;
    private NakedObject movieAdapter;
    private DummyReferenceData movieData;
    private DummyReferenceData personData;
    private TestProxyAssociation nameField;
    private NakedObject personAdapter;
    private AuthenticationManager mockAuthenticationManager;
    private ObjectEncoder mockObjectEncoder;

    @Before
    public void setUp() throws Exception {
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockObjectEncoder = (ObjectEncoder)this.mockery.mock(ObjectEncoder.class);
        this.server = new ServerFacadeImpl(this.mockAuthenticationManager);
        this.server.setEncoder(this.mockObjectEncoder);
        this.server.init();
        this.authenticationSession = NakedObjectsContext.getAuthenticationSession();
        this.movieAdapter = this.system.createPersistentTestObject();
        Oid movieOid = this.movieAdapter.getOid();
        this.movieData = new DummyReferenceData(movieOid, "none", this.movieAdapter.getVersion());
        TestProxySpecification spec = (TestProxySpecification)this.movieAdapter.getSpecification();
        this.nameField = new TestProxyAssociation("director", this.system.getSpecification(String.class));
        spec.setupFields(new NakedObjectAssociation[]{this.nameField});
        this.personAdapter = this.system.createPersistentTestObject();
        Oid personOid = this.personAdapter.getOid();
        this.personData = new DummyReferenceData(personOid, "none", this.personAdapter.getVersion());
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testClearAssociation() {
        NakedObjectsContext.getTransactionManager().startTransaction();
        ObjectData[] updatesData = this.server.clearAssociation(this.authenticationSession, "director", (IdentityData)this.movieData, (IdentityData)this.personData);
        NakedObjectsContext.getTransactionManager().endTransaction();
        this.nameField.assertFieldEmpty(this.movieAdapter);
        Assert.assertEquals((long)0L, (long)updatesData.length);
    }

    @Test
    public void testSetAssociation() {
        NakedObjectsContext.getTransactionManager().startTransaction();
        ObjectData[] updates = this.server.setAssociation(this.authenticationSession, "director", (IdentityData)this.movieData, (IdentityData)this.personData);
        NakedObjectsContext.getTransactionManager().endTransaction();
        this.nameField.assertField((Object)this.movieAdapter, this.personAdapter.getObject());
        Assert.assertEquals((long)0L, (long)updates.length);
    }

    @Test
    public void testSetAssociationFailsWithNonCurrentTarget() {
        this.movieAdapter.setOptimisticLock((Version)new TestProxyVersion(6));
        try {
            this.server.setAssociation(this.authenticationSession, "director", (IdentityData)this.movieData, (IdentityData)this.personData);
            Assert.fail();
        }
        catch (ConcurrencyException concurrencyException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAssociationFailsWhenInvisible() {
        this.nameField.setUpIsVisible(false);
        try {
            this.server.setAssociation(this.authenticationSession, "director", (IdentityData)this.movieData, (IdentityData)this.personData);
            Assert.fail();
        }
        catch (NakedObjectException expected) {
            Assert.assertEquals((Object)"can't modify field as not visible or editable", (Object)expected.getMessage());
        }
    }

    @Test
    public void testSetAssociationFailsWhenUnavailable() {
        this.nameField.setUpIsUnusableFor(this.movieAdapter);
        try {
            this.server.setAssociation(this.authenticationSession, "director", (IdentityData)this.movieData, (IdentityData)this.personData);
            Assert.fail();
        }
        catch (NakedObjectException expected) {
            Assert.assertEquals((Object)"can't modify field as not visible or editable", (Object)expected.getMessage());
        }
    }

    @Test
    public void testSetAssociationFailsWithNonCurrentAssociate() {
        this.personAdapter.setOptimisticLock((Version)new TestProxyVersion(6));
        try {
            this.server.setAssociation(this.authenticationSession, "director", (IdentityData)this.movieData, (IdentityData)this.personData);
            Assert.fail();
        }
        catch (ConcurrencyException concurrencyException) {
            // empty catch block
        }
    }
}

